c	Program: swrechv2.for
c	Author: Steve Larson, SSPA

c	Purpose: Processes KS data related to surface water use to develop
c	KS surface water recharge files for the RRCA Groundwater Model.
c
c	Version 2: This version is the same as swrech.for except it removes
c	the bi-linear interpolation.

c     Version 2 changes by spp:
c     a) July 2006: correct monthly factors for irrigation pumping distribution in file
c          monthlyfactorsbycounty.txt so that the same factors are used in both surface
c          and ground programs swrechv2 and pumprechv5.

c     b) July 2006: calculate node from row and column and write to plot files;
c        node number can be used in GIS to join data to grid for viewing.

c     Version 2h only: additional change by spp:
c     a) April 2006: read header records from files monthlyfactorsbycounty.txt,
c        authacresYYYY.txt and swrechYYYY.txt.
c
c     Compiled and linked with Lahey 95 v5.6 as follows:
c       lf95 swrechv2.for -chk -lst
c
      parameter (ny=165,nx=326)
      parameter (gdx=5280,gdy=5280)
      parameter (xg0=266023,yg0=14092806)
 
	dimension swret(400,400),acres(400,400),
     + dx(400),dy(400),sx(401),sy(401),ibound(400,400),
     + icty(400,400),xmonfactors(44,12),work(400,400),
     + xcoord(20,45,36,16),ycoord(20,45,36,16)

      parameter (nGroups=3000)      !dimensions for overlap groups
      dimension authtot(nGroups), swretloc(nGroups), acresloc(nGroups)

      dimension swretfactor(10)

      character*2 county,monthno(12)
      character*4 dspm,year
      character*11 swrechfile
      character*16 text
      character*128 header  !added for header records in two files (see v.2h above) --spp
      integer twnshp,range,sect,tract,grp,eof
      logical continue
c       added for version swrechv3.for -spp 3/10/2011
      character*40 chstatic !relative reference to folder path with static input files, esp. 40coords.DAT (16 MB)
      character*3 chout ! reference to subfolder out/ for output files --spp

      data dspm/'DSAA'/
      data monthno/'01','02','03','04','05','06','07','08','09','10',
     +   '11','12'/

c       relative reference to folder path with static input files, esp. 40coords.DAT (16 MB)
      data chstatic /'..\..\..\static\'/
      data chout /'ks/'/   !reference to subfolder for output files
c
      ier0=0
      if (IARGC().ne.1) then
        write(*,*) 'rerun with year as argument, e.g. swrech 2010'
        STOP
      end if

      call GETARG(1,year)        !arg 1: year (declared as character*4)

c load grid data and model origin
      open(12,file='../data/ks/sw/swrech.par',STATUS='OLD')  !added relative path chstatic --spp 3/10/2011
      ygtop=yg0+ny*gdy
c load return flow factors based on system type
	read(12,*) ntypes
	do n=1,ntypes
		read(12,*) swretfactor(n)
	end do
ccc      read(12,*) year  !get year from cmd line (above) so that input file is static --spp 3/10/2011
      close(12)
      write(*,*) '..Processing year ',year
	write(*,*) 'ny,nx,gdx,gdy,xg0,yg0: '
	write(*,*) ny,nx,gdx,gdy,xg0,yg0

      zmin=-1000.
      zmax=10000000.
c read ibound array
      write(*,*) '..reading ibound array'
      open(11,file='../static/02.ibound',STATUS='OLD')  !added relative path chstatic --spp 3/10/2011
          do i=1,ny
              read(11,'(326i2)') (ibound(j,i),j=1,nx)
          end do
      close(11)
c read county flags
      write(*,*) '..reading county flags'
      open(11,file='../data0/cty.flg',STATUS='OLD')  !added relative path chstatic --spp 3/10/2011
      read(11,*)
          do i=1,ny
              read(11,'(326i2)') (icty(j,i),j=1,nx)
          end do
      close(11)
c read monthly factors for counties
      write(*,*) '..reading monthly factors by county'
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C  Shares monthlyfactorsby county.txt with groundwater
C  Left in GW directory for backwards compatibility
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      open(11,file='../data/ks/gw/monthlyfactorsbycounty.txt',
     |     STATUS='OLD')  !added relative path chstatic --spp 3/10/2011
ccc      read(11,'(a)') header !added header to verify columns in file (version 2h only) --spp
      do nc=1,44
          read(11,*) ncx,(xmonfactors(nc,im),im=5,10)
      end do
      close(11)
c      pause

c zero working arrays
      do n=1,nGroups
         swretloc(n)=0.
         acresloc(n)=0.
         authtot(n)=0.
      end do

      swret=0.
      acres=0.

      mxGroup = 0  !initialize largest group no. read from file
      sumgwret=0.
      sumacres=0.
c accumulate authorized acres for each group
      write(*,*) '..reading authorized acreage by group'
      open(20,file='../data/ks/sw/authacres'//year//'.txt',STATUS='OLD')
ccc      read(20,'(a)') header  !added to verify columns in file (version 2h only) --spp
      continue=.true.
      sumauth=0.
      do while(continue.eqv..true.)
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif

         if (grp.gt.mxGroup) mxGroup = grp
         if(grp.lt.1.or.grp.gt.nGroups) then
           write(*,*) 'Group ',grp,' outside dimension limits.'
         else
           authtot(grp)=authtot(grp)+authacres
         end if
         sumauth=sumauth+authacres
      end do
      write(*,*) 'year, sum authorized acres over groups: '
      write(*,*) year,sumauth
      write(*,*) 'list groups with total authorized acres <= zero: '
C      pause
      do n=1,mxGroup
          if(authtot(n).le.0.)
     1      write(*,*) 'Group',n,authtot(n),' auth. acres'
      end do
      rewind(20)

c load tract coordinate data
      write(*,*) '..reading coordinates of 40-acre tracts'
      open(21,file='../data/ks/40coords.dat',STATUS='OLD')  !added relative path chstatic --spp 3/10/2011
      continue=.true.
      do while(continue.eqv..true.)
         read(21,*,iostat=eof) twnshp,range,sect,tract,x,y
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif
         xcoord(twnshp,range,sect,tract)=x
         ycoord(twnshp,range,sect,tract)=y
      end do
      close(21)

c loop over sw diversion and acreage data to accumulate by group
c compute sw return flow based on system type and diversion amount for each group
      write(*,*) '..reading diversion, acreage, and system type data'
      open(21,file='../data/ks/sw/swrech'//year//'.txt',STATUS='OLD')
ccc      read(21,'(a)') header !added to verify columns in file (version 2h only) --spp
      write(*,*) 'Expected fields: grp,pdiv,diversion,acloc,isystype'
c        1         2         3         4         5         6         7 2

      sumretout=0.
      sumacreageout=0.
      sumdiversion=0.
      do                    !c        do n=1,500
         read(21,*,iostat=eof) grp,pdiv,diversion,acloc,isystype
         if (eof.eq.-1) exit   !terminate do loop upon reaching end of file
cccc         read(21,*,end=100) grp,pdiv,diversion,acloc,isystype
         sumdiversion=sumdiversion+diversion
         isystype=isystype+1
         if (grp.le.nGroups) then
           swretloc(grp)=swretloc(grp)+diversion*swretfactor(isystype)
           acresloc(grp)=acresloc(grp)+acloc
           if(authtot(grp).le.0.) then
             sumretout=sumretout+diversion*swretfactor(isystype)
             sumacreageout=sumacreageout+acloc
           endif
         end if
	end do
	close(21)
ccc                                100  continue

      if (mxGroup.gt.nGroups) then
        write(*,*) 'WARNING: largest group no.',mxGroup,
     1     ' exceeds array dimension limit nGroups,',nGroups
      end if

c     open files for i/o
      open(14,file=chout//'output'//year//'.dat',STATUS='UNKNOWN')   !add path to subfolder chout = 'out/'
      open(9,file=chout//'check'//year//'.out',STATUS='UNKNOWN')     !add path to subfolder chout = 'out/'
      nout=0
c REPORTED SW RETURN AND IRRIGATED ACRES BY TRACT
      sumib=0.
      sumretout=0.
      sumacresout=0.
      continue=.true.
      do while(continue.eqv..true.)
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif
c         if(swretloc(grp).le.0.) cycle
         xoff=xcoord(twnshp,range,sect,tract)-xg0
         yoff=ygtop-ycoord(twnshp,range,sect,tract)
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         fct=authacres/authtot(grp)
c         write(14,*) n,nout,county,ibound(jloc,iloc),xoff,yoff,jloc,iloc
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
c        1         2         3         4         5         6         7 2
            write(14,*) nout,iloc,jloc,' (i,row,col) condition 1 '//
     1        '(column outside model grid):',authacres,'acres'
            cycle
c            pause
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' (i,row,col) condition 2 '//
     1        '(row outside model grid):',authacres,'acres'
            cycle
c            pause
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' (i,row,col) condition 3 '//
     1        '(inactive grid cell, ibound=0):',authacres,'acres'
            cycle
c            pause
         endif
            swret(jloc,iloc)=swret(jloc,iloc)+fct*swretloc(grp)
            acres(jloc,iloc)=acres(jloc,iloc)+fct*acresloc(grp)
      end do
      close(20)


c output totals to plot files
      write(*,*) '..writing plot files for returns and acreage'
      open(8,file=chout//'swretgrid'//year//'.dat',STATUS='UNKNOWN')   !add path to subfolder chout = 'out/'
      write(*,*) 'x_ft','y_ft','swret','row','col','node'
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.swret(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,swret(j,i),i,j,node
              endif
          end do
      end do
      close(8)
      open(8,file=chout//'swacresgrid'//year//'.dat',STATUS='UNKNOWN')   !add path to subfolder chout = 'out/'
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.acres(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,acres(j,i),i,j,node
              endif
          end do
      end do
      close(8)
c output data to rrpp files
c pumping and groundwater recharge files
c      open(9,file=chout//'check.out',STATUS='UNKNOWN')   !add path to subfolder chout = 'out/'
      write(*,*) '..writing monthly rcs files and asw file'
      sumtr=0.
      do im=5,10

         swrechfile=year//'.'//monthno(im)//'.rcs'
         write(9,*) swrechfile
         open(8,file=chout//swrechfile,STATUS='UNKNOWN')   !add path to subfolder chout = 'out/'
         sumr=0.
         do i=1,ny
            do j=1,nx
              work(j,i)=0.
              if(swret(j,i).gt.0.) then
                ic=icty(j,i)
                if(ic.eq.0) ic=1
                factor=xmonfactors(ic,im)
c                if(factor.eq.0.) write(14,*) ic,j,i,swret(j,i)
                work(j,i)=swret(j,i)*factor
                sumr=sumr+work(j,i)
              endif
            end do
            write(8,'(326f6.1)') (work(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) im,sumr
         sumtr=sumtr+sumr
      end do
c write out acres irrigated for the year
         open(8,file=chout//year//'.asw',STATUS='UNKNOWN')   !add path to subfolder chout = 'out/'
         suma=0.
         do i=1,ny
            do j=1,nx
                suma=suma+acres(j,i)
            end do
            write(8,'(326f6.1)') (acres(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) 'sumtr,suma,sumretout,sumacreageout,sumdiversion: '
         write(9,*) sumtr,suma,sumretout,sumacreageout,sumdiversion
         write(9,*) 'sumretout,sumacresout: '
         write(9,*) sumretout,sumacresout

	stop
	end
