c     Program: swrechv2.for
c     Author: Steve Larson, SSPA
c     Purpose: Processes KS data related to surface water use to
c     develope KS surface waterrecharge files for the RRCA Groundwater
c     Model.
c     Version: This version is the same as swrech.for except it removes
c     the bi-linear interpolation.
      parameter (ny=165,nx=326)
      parameter (gdx=5280,gdy=5280)
      parameter (xg0=266023,yg0=14092806)
      dimension swret(400,400),acres(400,400),
     + ibound(400,400),
     + icty(400,400),xmonfactors(44,12),work(400,400),authtot(3000),
     + xcoord(20,45,36,16),ycoord(20,45,36,16),swretloc(3000),
     + acresloc(3000),swretfactor(10)
      character*2 monthno(12)
      character*4 year
      character*14 swrechfile
      integer twnshp,range,sect,tract,grp,eof
      logical continue
      data monthno/'01','02','03','04','05','06','07','08','09','10',
     +   '11','12'/
      if (IARGC().ne.1) STOP 'Usage: swrechv2 <year>'
      call GETARG(1,year)
c load grid data and model origin
      open(12,file='../data/ks/sw/swrech.par',status='OLD')
      ygtop=yg0+ny*gdy
c load return flow factors based on system type
      write(*,*) ny,nx,gdx,gdy,xg0,yg0
      read(12,*) ntypes
      do n=1,ntypes
        read(12,*) swretfactor(n)
      end do
      write(*,*) '..Processing year ',year
      zmin=-1000.
      zmax=10000000.
c read ibound array
      write(*,*) '..reading ibound array'
      open(11,file='../static/02.ibound',status='OLD')
          do i=1,ny
              read(11,'(326i2)') (ibound(j,i),j=1,nx)
          end do
      close(11)
c read county flags
      write(*,*) '..reading county flags'
      open(11,file='../data0/cty.flg',status='OLD')
      read(11,*)
          do i=1,ny
              read(11,'(326i2)') (icty(j,i),j=1,nx)
          end do
      close(11)
c read monthly factors for counties
      write(*,*) '..reading monthly factors by county'
      open(11,file='../data/ks/sw/monthlyfactorsbycounty'//year//'.txt',
     |        status='OLD')
      do nc=1,44
          read(11,*) ncx,(xmonfactors(nc,im),im=5,10)
      end do
      close(11)
c      pause

c zero working arrays
      do n=1,3000
         swretloc(n)=0.
         acresloc(n)=0.
         authtot(n)=0.
      end do
      sumgwret=0.
      sumacres=0.
c accumulate authorized acres for each group
      write(*,*) '..reading authorized acreage by group'
      open(20,file='../data/ks/sw/authacres'//year//'.txt',status='OLD')
      continue=.true.
      sumauth=0.
      do while(continue.eqv..true.)
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif
         authtot(grp)=authtot(grp)+authacres
         sumauth=sumauth+authacres
      end do
      write(*,*) year,sumauth
C     pause
      do n=1,2905
          if(authtot(n).le.0.) write(*,*) n,authtot(n)
      end do
      rewind(20)


c load tract coordinate data
      write(*,*) '..reading coordinates of 40-acre tracts'
      open(21,file='../data/ks/40coords.dat',status='OLD')
      continue=.true.
      do while(continue.eqv..true.)
         read(21,*,iostat=eof) twnshp,range,sect,tract,x,y
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif
         xcoord(twnshp,range,sect,tract)=x
         ycoord(twnshp,range,sect,tract)=y
      end do
      close(21)

c loop over sw diversion and acreage data to accumulate by group
c compute sw return flow based on system type and diversion amount for each group
      write(*,*) '..reading diversion, acreage, and system type data'
      open(21,file='../data/ks/sw/swrech'//year//'.txt',status='OLD')
      sumretout=0.
      sumacreageout=0.
      sumdiversion=0.
      do n=1,500
         read(21,*,end=100) grp,pdiv,diversion,acloc,isystype
          sumdiversion=sumdiversion+diversion
         isystype=isystype+1
         swretloc(grp)=swretloc(grp)+diversion*swretfactor(isystype)
         acresloc(grp)=acresloc(grp)+acloc
          if(authtot(grp).le.0.) then
              sumretout=sumretout+diversion*swretfactor(isystype)
              sumacreageout=sumacreageout+acloc
          endif
      end do
      close(21)
 100  continue
c     open files for i/o
      open(14,file='ks/output'//year//'.dat')
      open(9,file='ks/check'//year//'.out')
      nout=0
c REPORTED SW RETURN AND IRRIGATED ACRES BY TRACT
      sumretout=0.
      sumacresout=0.
      continue=.true.
      do while(continue.eqv..true.)
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif
c         if(swretloc(grp).le.0.) cycle
         xoff=xcoord(twnshp,range,sect,tract)-xg0
         yoff=ygtop-ycoord(twnshp,range,sect,tract)
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         fct=authacres/authtot(grp)
c         write(14,*) n,nout,county,ibound(jloc,iloc),xoff,yoff,jloc,iloc
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
            write(14,*) nout,sumib,iloc,jloc,' sw return flow 1'
            cycle
c            pause
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            write(14,*) nout,sumib,iloc,jloc,' sw return flow 2'
            cycle
c            pause
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
            write(14,*) nout,sumib,iloc,jloc,' sw return flow 3'
            cycle
c            pause
         endif
            swret(jloc,iloc)=swret(jloc,iloc)+fct*swretloc(grp)
            acres(jloc,iloc)=acres(jloc,iloc)+fct*acresloc(grp)
      end do
      close(20)


c output totals to plot files
      write(*,*) '..writing plot files for returns and acreage'
      open(8,file='ks/swretgrid'//year//'.dat')
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.swret(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                write(8,*) xloc,yloc,swret(j,i),i,j
              endif
          end do
      end do
      close(8)
      open(8,file='ks/swacresgrid'//year//'.dat')
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.acres(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                write(8,*) xloc,yloc,acres(j,i),i,j
              endif
          end do
      end do
      close(8)
c output data to rrpp files
c pumping and groundwater recharge files
c      open(9,file='ks/check.out')
      write(*,*) '..writing monthly rcs files and asw file'
      sumtr=0.
      do im=5,10

         swrechfile='ks/'//year//'.'//monthno(im)//'.rcs'
         write(9,*) swrechfile
         open(8,file=swrechfile)
         sumr=0.
         do i=1,ny
            do j=1,nx
              work(j,i)=0.
              if(swret(j,i).gt.0.) then
                ic=icty(j,i)
                if(ic.eq.0) ic=1
                factor=xmonfactors(ic,im)
c                if(factor.eq.0.) write(14,*) ic,j,i,swret(j,i)
                work(j,i)=swret(j,i)*factor
                sumr=sumr+work(j,i)
              endif
            end do
            write(8,'(326f6.1)') (work(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) im,sumr
         sumtr=sumtr+sumr
      end do
c write out acres irrigated for the year
         open(8,file='ks/'//year//'.asw')
         suma=0.
         do i=1,ny
            do j=1,nx
                suma=suma+acres(j,i)
            end do
            write(8,'(326f6.1)') (acres(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) sumtr,suma,sumretout,sumacreageout,sumdiversion
         write(9,*) sumretout,sumacresout

      stop
      end
