c     Program pumprechv5.for
c     Author: Steve Larson, SSPA
c     Purpose: Processes Kansas wateruse data to produce groundwater
c     pumping and recharge files for the RRCA Groundwater Model
c     Version: This version is the same as pumprechv4.for except
c     for the removal of the bi-linear interpolation.
c     Version 5h: modified by spp:
c     a) April 2006: read header records from files
c          authacresYYYY.txt, pumprech2005.txt and 2005mi.txt.
c     b) July 2006: calculate node from row and column and write to plot files;
c        node number can be used in GIS to join data to grid for viewing.
c     c) July 2006: increase dimensioning for working arrays gwretloc, acresloc and authtot
c          from 3000 to nGroups; define the parameter nGroups=5000.  Groups 4001 and 4002
c          were added to the dataset in RRCS_Overlap_Groups_For2005_Final.xls to represent
c          two Nebraska wells with place of use in Kansas.
c
      parameter (ny=165,nx=326)
      parameter (gdx=5280,gdy=5280)
      parameter (xg0=266023,yg0=14092806)
      dimension pump(400,400),gwret(400,400),acres(400,400),
     + dx(400),dy(400),sx(401),sy(401),ibound(400,400),pumpmi(400,400),
     + icty(400,400),xmonfactors(44,12),work(400,400),
     + xcoord(20,45,36,16),ycoord(20,45,36,16)

      parameter (nGroups=5000)      !dimensions for overlap groups
      dimension authtot(nGroups), gwretloc(nGroups), acresloc(nGroups),
     +          almenapdivs(500)

      character*2 county,monthno(12)
      character*4 year
      character*14 pumpfile,gwrechfile
      integer twnshp,range,sect,tract,grp,eof,pdiv,almenapdivs
      logical continue
      data monthno/'01','02','03','04','05','06','07','08','09','10',
     +   '11','12'/
      if (IARGC().ne.1) STOP 'Usage: pumprechv5 <year>'
      call GETARG(1,year)
      write(*,*) '..Processing year: ',year
C     pause
      ygtop=yg0+ny*gdy
      zmin=-1000.
      zmax=10000000.
c read ibound array
      write(*,*) '..reading ibound'
      open(11,file='../static/02.ibound',status='OLD')
          do i=1,ny
              read(11,'(326i2)') (ibound(j,i),j=1,nx)
          end do
      close(11)
c read county flags
      write(*,*) '..reading county flags'
      open(11,file='../data0/cty.flg',status='OLD')
      read(11,*)
          do i=1,ny
              read(11,'(326i2)') (icty(j,i),j=1,nx)
          end do
      close(11)
c read monthly factors for counties
      write(*,*) '..reading monthly factors by county'
      open(11,file='../data/ks/gw/monthlyfactorsbycounty.txt',
     |        status='OLD')
      do nc=1,44
          read(11,*) ncx,(xmonfactors(nc,im),im=5,10)
      end do
      close(11)
c      pause

c read pdivs for almena district and area factor (percentage of gw only land)
      write(*,*) '..reading almena points of diversion'
      open(11,file='../data/ks/gw/almenapdivs'//year//'.txt',
     |        status='OLD')
      read(11,*) nalmenapdivs,almenafactor
      do n=1,nalmenapdivs
          read(11,*) almenapdivs(n)
      end do
      close(11)
c     zero working arrays
      do n=1,nGroups
         gwretloc(n)=0.
         acresloc(n)=0.
         authtot(n)=0.
      end do
      sumgwret=0.
      sumacres=0.
c     total auth acres for each grp
      write(*,*) '..reading authorized acres by group'
      open(20,file='../data/ks/gw/authacres'//year//'.txt',status='OLD')
      sumauth=0.
      do
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) exit
         authtot(grp)=authtot(grp)+authacres
         sumauth=sumauth+authacres
      end do
      write(*,*) 'sum authorized acres by group = ',sumauth
c      pause
c      do n=1,2905
c          if(authtot(n).le.0.) write(*,*) n,authtot(n)
c      end do
      rewind(20)

c     open files for i/o
      write(*,*) '..reading pumping file'
      open(13,file='../data/ks/gw/pumprech'//year//'.txt',status='OLD')
      open(14,file='ks/output'//year//'.dat')
      open(9,file='ks/check'//year//'.out')
      nout=0
      almenaacres=0.
      acresnotauthorized=0.
      gwretnotauthorized=0.
c loop over wells and accumulate totals in work arrays
c PUMPING
      do
c        do n=1,4689
         mxGroup=0
         read(13,*,iostat=eof) grp,pdiv,xloc,yloc,rfpercent,county,
     +                         pumploc,gwloc,acloc
         if (eof.eq.-1) exit
         xoff=xloc-xg0
         yoff=ygtop-yloc
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' pumping'
            cycle
c            pause
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' pumping'
            cycle
c            pause
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
             write(14,*) iloc,jloc,pumploc,' pumping'
             cycle
         endif
         if(pumploc.gt.0.) then
            pump(jloc,iloc)=pump(jloc,iloc)+pumploc
         endif

         if(grp.lt.1.or.grp.gt.nGroups)
     1     write(*,*) 'Group ',grp,' outside dimension limits.'
         if(grp.gt.mxGroup) mxGroup = grp

c        total recorded gw return and irr acres for each grp
         gwretloc(grp)=gwretloc(grp)+gwloc
         aclocfactor=1.0000000
         do nalmena=1,nalmenapdivs
            if(pdiv.eq.almenapdivs(nalmena)) then
               aclocfactor=almenafactor
               almenaacres=almenaacres+acloc
c                write(*,*) pdiv,almenapdivs(n),acloc,almenaacres
               if(authtot(grp).eq.0.) then
               write(*,*) grp,gwret,acloc
C                 pause
               endif
            endif
         end do
c         write(*,*) aclocfactor,acloc
c         pause
         acresloc(grp)=acresloc(grp)+acloc*aclocfactor
         sumgwret=sumgwret+gwloc
         sumacres=sumacres+acloc*aclocfactor
         if (authtot(grp).eq.0.) then
             acresnotauthorized=acresnotauthorized+acloc*aclocfactor
             gwretnotauthorized=gwretnotauthorized+gwloc
             write(14,*) grp,gwloc,acloc,gwretnotauthorized,
     +          acresnotauthorized
         endif
      end do
      close(13)
      write(*,*) 'sums (sumgwret, sumacres,almenaacres,'
      write(*,*) '      gwretnotauthorized, acresnotauthorized): '
      write(*,*) sumgwret,sumacres,almenaacres,gwretnotauthorized,
     +          acresnotauthorized
      write(14,*) sumgwret,sumacres,almenaacres,gwretnotauthorized,
     +          acresnotauthorized

c sum the acreage used over the user groups
      sumtest=0.
      do n=1,nGroups
          sumtest=sumtest+acresloc(n)
      end do
      write(*,*) 'sum over acresloc(n):', sumtest
C     pause
c     load tract coord arrays
      write(*,*) '..reading coordinates of 40-acre tracts'
      open(21,file='../data/ks/40coords.dat',status='OLD')
      continue=.true.
      do while(continue.eqv..true.)
         read(21,*,iostat=eof) twnshp,range,sect,tract,x,y
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif
         xcoord(twnshp,range,sect,tract)=x
         ycoord(twnshp,range,sect,tract)=y
      end do
      close(21)

c REPORTED GW RETURN AND IRRIGATED ACRES BY TRACT
      ygtop=yg0+ny*gdy
      do
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) exit
c         if(gwretloc(grp).le.0.) cycle
         xoff=xcoord(twnshp,range,sect,tract)-xg0
         yoff=ygtop-ycoord(twnshp,range,sect,tract)
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         fct=authacres/authtot(grp)
c         write(14,*) n,nout,county,ibound(jloc,iloc),xoff,yoff,jloc,iloc
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' return flow 1'
            cycle
c            pause
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,'return flow '
            cycle
c            pause
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
            write(14,*) grp,tract,iloc,jloc,gwretloc(grp)*fct,
     +        acresloc(grp)*fct,'I'
            cycle
         endif
c         if(gwretloc(grp).gt.0.) then
c            if(acresloc(grp).eq.0) acresloc=pumploc/1.055888173
            gwret(jloc,iloc)=gwret(jloc,iloc)+fct*gwretloc(grp)
            acres(jloc,iloc)=acres(jloc,iloc)+fct*acresloc(grp)
      end do
      close(20)


c output totals to plot files
      write(*,*) '..writing plot files'
      open(8,file='ks/pumpgrid'//year//'.dat')
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.pump(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,pump(j,i),i,j,node
c                if(icty(j,i).gt.22.or.icty(j,i).lt.9) then
c                  write(*,*) j,i,icty(j,i)
c                  pause
c                endif
              endif
          end do
      end do
      close(8)
      open(8,file='ks/gwretgrid'//year//'.dat')
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.gwret(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,gwret(j,i),i,j,node
c                if(icty(j,i).gt.22.or.icty(j,i).lt.9) then
c                  write(*,*) j,i,icty(j,i)
c                  pause
c                endif
              endif
          end do
      end do
      close(8)
      open(8,file='ks/acresgrid'//year//'.dat')
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.acres(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,acres(j,i),i,j,node
              endif
          end do
      end do
      close(8)
c output data to rrpp files
c pumping and groundwater recharge files
c      open(9,file='ks/check.out')
      write(*,*) '..writing pmp, rcg, and agw files'
      sumtp=0.
      sumtr=0.
      do im=5,10
         pumpfile='ks/'//year//'.'//monthno(im)//'.pmp'
         write(9,*) pumpfile
         open(8,file=pumpfile)
         sump=0.
         do i=1,ny
            do j=1,nx
              work(j,i)=0.
              if(pump(j,i).gt.0.) then
                ic=icty(j,i)
                if(ic.eq.0) ic=1
                factor=xmonfactors(ic,im)
                work(j,i)=pump(j,i)*factor
                sump=sump+work(j,i)
              endif
            end do
            write(8,'(326f6.1)') (work(j,i),j=1,nx)
         end do
         close(8)

         gwrechfile='ks/'//year//'.'//monthno(im)//'.rcg'
         write(9,*) gwrechfile
         open(8,file=gwrechfile)
         sumr=0.
         do i=1,ny
            do j=1,nx
              work(j,i)=0.
              if(gwret(j,i).gt.0.) then
                ic=icty(j,i)
                if(ic.eq.0) ic=1
                factor=xmonfactors(ic,im)
                work(j,i)=gwret(j,i)*factor
                sumr=sumr+work(j,i)
              endif
            end do
            write(8,'(326f6.1)') (work(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) im,sump,sumr
         sumtp=sumtp+sump
         sumtr=sumtr+sumr
      end do
c write out acres irrigated for the year
         open(8,file='ks/'//year//'.agw')
         suma=0.
         do i=1,ny
            do j=1,nx
                suma=suma+acres(j,i)
            end do
            write(8,'(326f6.1)') (acres(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) 'pumping'
         write(9,*) sumtp
         write(9,*) 'gw returns'
         write(9,*) sumtr
         write(9,*) 'gw acres'
         write(9,*) suma

c process annual m&i pumping data into model grid and into .mi file
      write(*,*) '..reading m&i file'
      open(13,file='../data/ks/gw/'//year//'mi.txt',status='OLD')
      sumout=0.
      do n=1,600
         read(13,*,end=500) grp,pdiv,xloc,yloc,rfpercent,pumploc,
     +       gwretmiloc,xnetloc
c         pause
c         write(*,*) xloc,yloc,rfpercent,county,pumploc,
c     +       gwretmiloc,xnetloc
c         pause
         xoff=xloc-xg0
         yoff=ygtop-yloc
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         inside=0
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
            sumout=sumout+xnetloc
            write(14,*) nout,iloc,jloc,grp,pdiv,xnetloc,
     +           sumout,' miloc'
            cycle
c            pause
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            sumout=sumout+xnetloc
            write(14,*) nout,iloc,jloc,grp,pdiv,xnetloc,
     +          sumout,' miloc'
            cycle
c            pause
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
            write(14,*) nout,jloc,iloc,' miloc'
            cycle
         endif
         if(xnetloc.gt.0.) then
            pumpmi(jloc,iloc)=pumpmi(jloc,iloc)+xnetloc
         endif
      end do
 500  close(13)
c output totals to plot files
      write(*,*) '..write mi plot file'
      open(8,file='ks/'//year//'migrid.dat')
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.pumpmi(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,pumpmi(j,i),i,j,node
c                if(icty(j,i).gt.22.or.icty(j,i).lt.9) then
c                  write(*,*) j,i,icty(j,i)
c                  pause
c                endif
              endif
          end do
      end do
      close(8)
c write out m&i pumping for the year
         open(8,file='ks/'//year//'.mi')
         suma=0.
         do i=1,ny
            do j=1,nx
                suma=suma+pumpmi(j,i)
            end do
            write(8,'(326f6.1)') (pumpmi(j,i),j=1,nx)
         end do
         close(8)

         write(9,*) 'm&i pumping'
         write(9,*) suma
      stop
      end
