c	Program pumprechv10.for
c	Author: Steve Larson, SSPA

c	Purpose: Processes Kansas wateruse data to produce groundwater
c	pumping and recharge files for the RRCA Groundwater Model
c	Version: This version is the same as pumprechv4.for except
c	for the removal of the bi-linear interpolation.
c
c     Version 9 (spp, 4/15/2015): modified to write two additional fields to diagnostic output file authacresYYYY.out.
c       Added fields are acres(jloc,iloc), to show cumulative gw acres in cell corresponding to authorized tract, and
c       node number [node = 326*(iloc - 1) + jloc for row iloc and column jloc].
c
c     Version 8 (spp, 7/8/2011): modified to calculate pd-pu distances between the centroid of pds
c       within a group(miles) and its corresponding place of use for each tract, given by variable distpdpu_mi;
c       and a nominal range of distance for pds within the group, given by
c         pdrange_mi = sqrt[(max(xi - xj))^2 + (max(yi - yj))^2]/5280 for pds i and j within the group. The diagnostic
c         output file authacresYYYY.out, added in Version 6 (see below), was expanded to list the projected
c         coordinates of each place of use (xloc,yloc), centroid of points of diversion, and the above two
c         variables distpdpu_mi and pdrange_mi.
c
c     Version 7 (spp, 3/2011): modified to reference a single set of static input files
c       for current and future program runs to process pumping data.
c
c     Version 6 (spp): writes additional diagnostic output file of authorized place of use: file authacresYYYY.out
c       --shows orig. input plus (x,y) coords (ft), (row,col) indices, cumul. area in grid cell, cumul. return flow in grid cell
c       --spp Apr 21, 2010

c     Version 5 changes by spp:
c     a) July 2006: correct monthly factors for irrigation pumping distribution in file
c          monthlyfactorsbycounty.txt so that the same factors are used in both surface
c          and ground programs swrechv2 and pumprechv5.

c     b) July 2006: calculate node from row and column and write to plot files;
c        node number can be used in GIS to join data to grid for viewing.

c     c) July 2006: increase dimensioning for working arrays gwretloc, acresloc and authtot
c          from 3000 to nGroups; define the parameter nGroups=5000.  Groups 4001 and 4002
c          were added to the dataset in RRCS_Overlap_Groups_For2005_Final.xls to represent
c          two Nebraska wells with place of use in Kansas.
c
c     d) July 2008: add some documentation (definitions for input variables read from pumprechYYYY.txt
c          and YYYYmi.txt).

c     Version 5h only: additional change by spp:
c     a) April 2006: read header records from files monthlyfactorsbycounty.txt,
c          authacresYYYY.txt, pumprech2005.txt and 2005mi.txt.
c
c     Compiled and linked with Lahey 95 v5.6 as follows:
c       lf95 pumprechv5.for -chk -lst
! source code notes

! Compiling with Gnu Fortran:
! Prior to compiling, linking or running:
!   set path=%path%;C:\MinGW\bin\
! To compile:
!   Switches: -c: Compile without linking; -o link without compiling; -ffree-line-length-none (free format source code, no line length limit), -Wall (Warnings all)
!   gfortran  -c -Wall -Wextra -fcheck=bounds -Fbacktrace pumprechv10.for
!   gfortran -static -o pumprechv10 pumprechv10.o
c
      program pumprechv10
      parameter (ny=165,nx=326)
      parameter (gdx=5280,gdy=5280)
      parameter (xg0=266023,yg0=14092806)

      dimension pump(400,400),gwret(400,400),acres(400,400),
     + dx(400),dy(400),sx(401),sy(401),ibound(400,400),pumpmi(400,400),
     + icty(400,400),xmonfactors(44,12),work(400,400),
     + xcoord(20,45,36,16),ycoord(20,45,36,16)

      parameter (nGroups=5000)      !dimensions for overlap groups
      dimension authtot(nGroups), gwretloc(nGroups), acresloc(nGroups)

      dimension almenapdivs(500)

      character*2 county,monthno(12)
      character*4 dspm,year
      character*10 chalmena_factor
      character*11 pumpfile,gwrechfile
      character*16 text
      character*128 header  !added for header records in two files (see v.2h above) --spp
      integer twnshp,range,sect,tract,grp,eof,pdiv,almenapdivs
      logical continue
c       added for version pumprechv6.for -spp 3/10/2011
      character*40 chstatic !relative reference to folder path with static input files, esp. 40coords.DAT (16 MB)
      character*3 chout ! reference to subfolder out/ for output files --spp

      integer npd(nGroups) !counter for no. pds per group
      dimension xpd(nGroups), ypd(nGroups)        !pd projected coordinates (centroid for groups with more than one pd)
      dimension xpdmin(nGroups), xpdmax(nGroups)  !min & max projected x-coordinates for pds within each group
      dimension ypdmin(nGroups), ypdmax(nGroups)  !min & max projected y-coordinates for pds within each group
      dimension pdrange(nGroups)                  !range of pds within group, i.e., max distance between pds within group (zero for npd=1)

      parameter (maxna=100)  !maximum no. of pds without authorized place of use
      integer numna          !no. of pds without authorized place of use up to maxna
      integer node           !node number corresponding to row i and column j for nx columns: node = nx*(i-1) + j
      integer grpna(maxna)   !group number of pd without authorized place of use
      integer nodena(maxna)  !location (node) of pd without authorized place of use
      real aclocna(maxna)    !unauthorized irrigation area
      real gwlocna(maxna)    !unauthorized irrigation return flow
      real reassgn

      data dspm/'DSAA'/
      data monthno/'01','02','03','04','05','06','07','08','09','10',
     +   '11','12'/

c       relative reference to folder path with static input files, esp. 40coords.DAT (16 MB)
      data chstatic /'../data/ks/gw/'/
      data chout /'ks/'/   !reference to subfolder for output files
c
      ier0=0
      if (IARGC().ne.2) then
        write(*,*) 'usage: pumprechv9 [year] [almena factor]'
        write(*,*) 'ex. for 2010: pumprechv9 2010 0.7187758'
        STOP
      end if
c
c Note: Almena area factor = gw-exclusive irrigated area as fraction of total irrigated area in Almena district.

      call GETARG(1,year)            !arg 1: year (declared as character*4)
      call GETARG(2,chalmena_factor) !arg 2: almena factor (text version, declared as character*10)
      write(*,*) 'run for year '//year//
     |           ', almena factor='//chalmena_factor
      read(chalmena_factor,'(G32.0)') almenafactor      !replace trim(chalmena_factor) with chalmena_factor
      write(*,*) ' real version: ',almenafactor
ccc      STOP

C     open(12,file=trim(chstatic)//'pumprech.par') !added relative path chstatic --spp 3/10/2011
C     read(12,*) ny,nx                             !no. rows, no. columns
C     read(12,*) gdx,gdy
C     read(12,*) xg0,yg0
ccc      read(12,*) year  !get year from cmd line (above) so that input file is static --spp 3/10/2011
C     close(12)
      write(*,*) '..Processing year: ',year,
     |           ' Almena gw-ex area fraction=',almenafactor

      ygtop=yg0+ny*gdy
      zmin=-1000.
      zmax=10000000.
c read ibound array
      write(*,*) '..reading ibound'
      open(11,file='../static/02.ibound') !added relative path chstatic --spp 3/10/2011
          do i=1,ny
              read(11,'(326i2)') (ibound(j,i),j=1,nx)
          end do
      close(11)
c read county flags
      write(*,*) '..reading county flags'
      open(11,file='../data0/cty.flg') !added relative path chstatic --spp 3/10/2011
      read(11,*)
          do i=1,ny
              read(11,'(326i2)') (icty(j,i),j=1,nx)
          end do
      close(11)
c read monthly factors for counties
      write(*,*) '..reading monthly factors by county'
      open(11,file=trim(chstatic)//'monthlyfactorsbycounty.txt') !added relative path chstatic --spp 3/10/2011
ccc      read(11,'(a)') header !added header to verify columns in file (version 5h only) --spp
      write(*,*) 'Expected fields: index,may,jun,jul,aug,sep,oct,county'
      do nc=1,44
          read(11,*) ncx,(xmonfactors(nc,im),im=5,10)
      end do
      close(11)

c read pdivs for almena district
      write(*,*) '..reading almena points of diversion'
      open(11,file=trim(chstatic)//'almenapdivs.txt',
     |     STATUS='OLD')
      read(11,*) nalmenapdivs
      do n=1,nalmenapdivs
          read(11,*) almenapdivs(n)
      end do
      close(11)

c     zero working arrays
      do n=1,nGroups
         gwretloc(n)=0.
         acresloc(n)=0.
         authtot(n)=0.
      end do

      pump=0.
      gwret=0.
      acres=0.
      pumpmi=0.

      mxGroup = 0  !initialize largest group no. read from file

      sumgwret=0.
      sumacres=0.
      acresmax=0.
      acresmin=0.
c     total auth acres for each grp
      write(*,*) '..reading authorized acres by group'
      open(20,file=trim(chstatic)//'authacres'//year//'.txt',
     |        STATUS='OLD')
ccc      read(20,'(a)') header !added to verify columns in file (version 5h only) --spp
      write(*,*)
     1  'Expected fields: grp,twnshp,range,sect,tract,authacres'
c        1         2         3         4         5         6         7 2
      sumauth=0.
      do
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) exit

         if (grp.gt.mxGroup) mxGroup = grp
         if (grp.le.nGroups)
     1     authtot(grp)=authtot(grp)+authacres
         sumauth=sumauth+authacres
      end do
      write(*,*) 'sum authorized acres by group = ',sumauth

c      do n=1,2905
c          if(authtot(n).le.0.) write(*,*) n,authtot(n)
c      end do
      rewind(20)

c     open files for i/o
      write(*,*) '..reading pumping file'
      open(13,file=trim(chstatic)//'pumprech'//year//'.txt',
     |        STATUS='OLD')
ccc      read(13,'(a)') header !added to verify columns in file (version 5h only) --spp
      open(14,file=chout//'output'//year//'.dat',STATUS='UNKNOWN')   !add path to subfolder chout = 'out/'
      open(9,file=chout//'check'//year//'.out',STATUS='UNKNOWN')     !add path to subfolder chout = 'out/'

      write(14,*) 'grp','gwloc','acloc','gwrfnotauth','gwacnotauth',
     |            'iloc','jloc','nodena','numna'
      nout=0
      almenaacres=0.

      numna=0    !initialize no. of pds without authorized place of use up to maxna
      nodena=0   !initialize array of locations of pds without authorized place of use
      aclocna=0  !initialize array of unauthorized irrigation area
      gwlocna=0  !initialize array of unauthorized gw return flow

      acresnotauthorized=0.
      gwretnotauthorized=0.

c       initialize location arrays for groups:
      npd=0
      xpd=0
      ypd=0
      xpdmin=0
      xpdmax=0
      ypdmin=0
      ypdmax=0
      pdrange=0

c loop over wells and accumulate totals in work arrays
c PUMPING
      do
c        definitions: fields read from file pumprechYYYY.txt:
c            var name | spreadsheet field name, definition (Rptd_GW_Irr_Use_YYYY)
c            grp=group_no, pdiv=pdiv_id,
c            (xloc,yloc) = pt of diversion projected coordinates (UTM-14 NAD27 ft),
c            rfpercent = recharge rate (return flow fraction of pumping),
c            county = county abbreviation (2 characters),
c            pumploc = reported pumping (af),
c            gwloc = return flow (af) = rfpercent*pumploc,
c            acloc = reported irrigation acres.
c        do n=1,4689
         mxGroup=0
         read(13,*,iostat=eof) grp,pdiv,xloc,yloc,rfpercent,county,
     +                         pumploc,gwloc,acloc
         if (eof.eq.-1) exit

         xoff=xloc-xg0
         yoff=ygtop-yloc
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' pumping'
            cycle
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' pumping'
            cycle
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
             write(14,*) iloc,jloc,pumploc,' pumping'
             cycle
         endif
         if(pumploc.gt.0.) then
            pump(jloc,iloc)=pump(jloc,iloc)+pumploc
         endif

         if(grp.lt.1.or.grp.gt.nGroups)
     1     write(*,*) 'Group ',grp,' outside dimension limits.'
         if(grp.gt.mxGroup) mxGroup = grp

c        calculate avg location of pds within each grp in active model domain
         npd(grp)=npd(grp)+1
         xpd(grp)=xpd(grp)+xloc
         ypd(grp)=ypd(grp)+yloc

         if (npd(grp).eq.1) then
           xpdmin(grp)=xloc
           xpdmax(grp)=xloc
           ypdmin(grp)=yloc
           ypdmax(grp)=yloc
         else
           xpdmin(grp)=MIN(xpdmin(grp),xloc)
           xpdmax(grp)=MAX(xpdmax(grp),xloc)
           ypdmin(grp)=MIN(ypdmin(grp),yloc)
           ypdmax(grp)=MAX(ypdmax(grp),yloc)
         endif

c        total recorded gw return and irr acres for each grp
         gwretloc(grp)=gwretloc(grp)+gwloc
         aclocfactor=1.0000000
         do nalmena=1,nalmenapdivs
            if(pdiv.eq.almenapdivs(nalmena)) then
               aclocfactor=almenafactor
               almenaacres=almenaacres+acloc
c                write(*,*) pdiv,almenapdivs(n),acloc,almenaacres
                 if(authtot(grp).eq.0.) then
                   write(*,*) 'grp ',grp,
     |                          ' gwret ',gwret,' acloc ',acloc
c        1         2         3         4         5         6         7 2
                 endif
            endif
         end do
c	   write(*,*) aclocfactor,acloc
         acresloc(grp)=acresloc(grp)+acloc*aclocfactor
         sumgwret=sumgwret+gwloc
         sumacres=sumacres+acloc*aclocfactor

c Build list of unknown groups with  the associated pd locations, gw returns and irrigated area:

         if (authtot(grp).eq.0.) then
           numna=numna+1  !number of instances of pumping without authorized place of use
           node = nx*(iloc-1)+jloc
           acresnotauthorized=acresnotauthorized+acloc*aclocfactor
           gwretnotauthorized=gwretnotauthorized+gwloc
           write(14,*) grp,gwloc,acloc,gwretnotauthorized,
     +                 acresnotauthorized,iloc,jloc,node,numna

c            store up to maxna instances of unauthorized place of use.
c            (dimensioning parameter maxna is currently set to 100.)
           if(numna.le.maxna) then
             grpna(numna)   = grp
             nodena(numna)  = node
             aclocna(numna) = acloc*aclocfactor
             gwlocna(numna) = gwloc
           endif
         endif
      end do
      close(13)
      write(*,*) 'sums (sumgwret, sumacres,almenaacres,'
      write(*,*) '      gwretnotauthorized, acresnotauthorized): '
      write(*,*) sumgwret,sumacres,almenaacres,gwretnotauthorized,
     +          acresnotauthorized
      write(14,*) 'sums_gwret','acloc*alm.fact.','almena.ac',
     |            'gwretnotauth.', 'acresnotauth.'

      write(14,*) sumgwret,sumacres,almenaacres,gwretnotauthorized,
     +          acresnotauthorized

      if (mxGroup.gt.nGroups) then
        write(*,*) 'WARNING: largest group no.',mxGroup,
     1     ' exceeds array dimension limit nGroups,',nGroups
      end if

c sum the acreage used over the user groups
      sumtest=0.
      do grp=1,nGroups
        sumtest=sumtest+acresloc(grp)
c         centroid of each group's pds:
        if (npd(grp).gt.1) then
          xpd(grp)=xpd(grp)/npd(grp)
          ypd(grp)=ypd(grp)/npd(grp)
          pdrange(grp) = SQRT((xpdmax(grp) - xpdmin(grp))**2 +
     |                        (ypdmax(grp) - ypdmin(grp))**2)/5280
        endif
      end do
c        1         2         3         4         5         6         7 2
      write(*,*) 'sum over acresloc(grp):', sumtest

c     load tract coord arrays
      write(*,*) '..reading coordinates of 40-acre tracts'
      open(21,file='../data/ks/40coords.dat',STATUS='OLD') !added relative path chstatic --spp 3/10/2011
      continue=.true.
      do while(continue.eqv..true.)
         read(21,*,iostat=eof) twnshp,range,sect,tract,x,y
         if (eof.eq.-1) then
              continue=.false.
              exit
         else
              continue=.true.
         endif
         xcoord(twnshp,range,sect,tract)=x
         ycoord(twnshp,range,sect,tract)=y
      end do
      close(21)

c REPORTED GW RETURN AND IRRIGATED ACRES BY TRACT

c       for output: add (x,y) coords (ft), (row,col) indices, cumul. area in grid cell, cumul. return flow in grid cell --spp Apr 21, 2010
      open(30,file=chout//'authacres'//year//'.out',STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
      write(30,*)
     |  ' grp',' twnshp',' range',' sect',' tract', ' authacres',
     |  ' fct', ' xloc',' yloc',' row',' col',' fct=authacres/authtot',
     |  ' ibound(jloc,iloc)',' npd(grp)',' xpd(grp)',' ypd(grp)',
     |  ' distpdpu_mi',' pdrange_mi',' acres(jloc,iloc)',' node'
c        1         2         3         4         5         6         7 2
      ygtop=yg0+ny*gdy
      do
         read(20,*,iostat=eof) grp,twnshp,range,sect,tract,authacres
         if (eof.eq.-1) exit     !terminate do loop upon reaching end of file
c         if(gwretloc(grp).le.0.) cycle
         xloc=xcoord(twnshp,range,sect,tract)
         yloc=ycoord(twnshp,range,sect,tract)

         if (npd(grp).ge.1) then
           distpdpu=SQRT((xpd(grp)-xloc)**2 + (ypd(grp)-yloc)**2)/5280
         else
           distpdpu=0
         endif
c        1         2         3         4         5         6         7 2

         xoff=xloc-xg0
         yoff=ygtop-yloc
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         node=326*(iloc-1)+jloc
         fct=authacres/authtot(grp)
c        1         2         3         4         5         6         7 2
         if (jloc.gt.0.and.jloc.le.nx.and.iloc.gt.0.and.iloc.le.ny)then
           ibnd=ibound(jloc,iloc)
         else
           ibnd=-99
         endif
c         write(14,*) n,nout,county,ibound(jloc,iloc),xoff,yoff,jloc,iloc
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,' return flow 1'
            cycle
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            write(14,*) nout,iloc,jloc,'return flow '
            cycle
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
            write(14,*) grp,tract,iloc,jloc,gwretloc(grp)*fct,
     +        acresloc(grp)*fct,'I'
            cycle
         endif
c         if(gwretloc(grp).gt.0.) then
            gwret(jloc,iloc)=gwret(jloc,iloc)+fct*gwretloc(grp)
            acres(jloc,iloc)=acres(jloc,iloc)+fct*acresloc(grp)

         write(30,*,iostat=eof) grp,twnshp,range,sect,tract,authacres,
     |     fct,xloc,yloc,iloc,jloc,fct,ibnd,npd(grp),xpd(grp),ypd(grp),
     |     distpdpu,pdrange(grp),acres(jloc,iloc),node

      end do
      close(20)
      close(30)
c
c Irrigation area and return flow has been assigned to authorized place of use, above.
c Now assign list of unauthorized acres and return flow at point of diversion
c but not to exceed grid cell size.

      if (numna.gt.0) then
        write(14,*) 'reassign unauthorized place of use to pd'
        write(14,*) 'idxna',' grpna(idxna)',' reassgn'
        do idxna=1,numna
          node = nodena(idxna)
          iloc=Int((node-1)/nx)+1   !row
          jloc=Mod(node-1,nx)+1     !column
          if(acres(jloc,iloc).lt.640.) then
            reassgn = Min(640.-acres(jloc,iloc),aclocna(idxna))
            acres(jloc,iloc) = acres(jloc,iloc) + reassgn
            gwret(jloc,iloc)=gwret(jloc,iloc) + gwlocna(idxna)
          else
            reassgn=0.
          endif
          write(14,*) idxna,grpna(idxna),reassgn
        enddo
      endif

c output totals to plot files
      write(*,*) '..writing plot files'
      open(8,file=chout//'pumpgrid'//year//'.dat',STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.pump(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,pump(j,i),i,j,node
c                if(icty(j,i).gt.22.or.icty(j,i).lt.9) then
c                  write(*,*) j,i,icty(j,i)
c                endif
              endif
          end do
      end do
      close(8)
      open(8,file=chout//'gwretgrid'//year//'.dat',STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.gwret(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,gwret(j,i),i,j,node
c                if(icty(j,i).gt.22.or.icty(j,i).lt.9) then
c                  write(*,*) j,i,icty(j,i)
c                endif
              endif
          end do
      end do
      close(8)
      open(8,file=chout//'acresgrid'//year//'.dat',STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.acres(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,acres(j,i),i,j,node
              endif
          end do
      end do
      close(8)
c output data to rrpp files
c pumping and groundwater recharge files
c      open(9,file=chout//'check.out')  !add subfolder path for output files chout='out/'
      write(*,*) '..writing pmp, rcg, and agw files'
      sumtp=0.
      sumtr=0.
      do im=5,10
         pumpfile=year//'.'//monthno(im)//'.pmp'
         write(9,*) pumpfile
         open(8,file=chout//pumpfile,STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
         sump=0.
         do i=1,ny
            do j=1,nx
              work(j,i)=0.
              if(pump(j,i).gt.0.) then
                ic=icty(j,i)
                if(ic.eq.0) ic=1
                factor=xmonfactors(ic,im)
                work(j,i)=pump(j,i)*factor
                sump=sump+work(j,i)
              endif
            end do
            write(8,'(326f6.1)') (work(j,i),j=1,nx)
         end do
         close(8)

         gwrechfile=year//'.'//monthno(im)//'.rcg'
         write(9,*) gwrechfile
         open(8,file=chout//gwrechfile,STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
         sumr=0.
         do i=1,ny
            do j=1,nx
              work(j,i)=0.
              if(gwret(j,i).gt.0.) then
                ic=icty(j,i)
                if(ic.eq.0) ic=1
                factor=xmonfactors(ic,im)
                work(j,i)=gwret(j,i)*factor
                sumr=sumr+work(j,i)
              endif
            end do
            write(8,'(326f6.1)') (work(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) im,sump,sumr
         sumtp=sumtp+sump
         sumtr=sumtr+sumr
      end do
c write out acres irrigated for the year
         open(8,file=chout//year//'.agw',STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
         suma=0.
         do i=1,ny
            do j=1,nx
                suma=suma+acres(j,i)
            end do
            write(8,'(326f6.1)') (acres(j,i),j=1,nx)
         end do
         close(8)
         write(9,*) 'pumping'
         write(9,*) sumtp
         write(9,*) 'gw returns'
         write(9,*) sumtr
         write(9,*) 'gw acres'
         write(9,*) suma

c process annual m&i pumping data into model grid and into .mi file
      write(*,*) '..reading m&i file'
      open(13,file=trim(chstatic)//year//'mi.txt',STATUS='OLD')
ccc      read(13,'(a)') header        !added to verify columns in file (version 5h only) --spp
      sumout=0.
      nmi=0  !initialize no. m&i recs read
      do
c        definitions: fields read from file 2007mi.txt:
c            var name | spreadsheet field name, definition (Rptd_GW_Irr_Use_2007)
c            grp=group_no
c            pdiv=pdiv_id
c            (xloc,yloc) = (x_mod,y_mod): pt of diversion projected coordinates (UTM-14 NAD27 ft),
c            rfpercent = recharge rate (return flow fraction of pumping),
c            county = county abbreviation (2 characters),
c            pumploc = reported pumping (af),
c            gwretmiloc = return flow (af) = rfpercent*pumploc,
c            xnetloc = net pumping = pumploc - gwretmiloc.

         read(13,*,iostat=eof) grp,pdiv,xloc,yloc,rfpercent,pumploc,
     +       gwretmiloc,xnetloc

         if (eof.eq.-1) exit     !terminate do loop upon reaching end of file
         nmi=nmi+1
c         write(*,*) xloc,yloc,rfpercent,county,pumploc,
c     +       gwretmiloc,xnetloc
         xoff=xloc-xg0
         yoff=ygtop-yloc
         jloc=xoff/gdx+1.0
         iloc=yoff/gdy+1.0
         inside=0
         if(jloc.lt.1.or.jloc.gt.nx) then
            nout=nout+1
            sumout=sumout+xnetloc
            write(14,*) nout,iloc,jloc,grp,pdiv,xnetloc,
     +           sumout,' miloc'
            cycle
         endif
         if(iloc.lt.1.or.iloc.gt.ny) then
            nout=nout+1
            sumout=sumout+xnetloc
            write(14,*) nout,iloc,jloc,grp,pdiv,xnetloc,
     +          sumout,' miloc'
            cycle
         endif
         if(ibound(jloc,iloc).eq.0) then
            nout=nout+1
            write(14,*) nout,jloc,iloc,' miloc'
            cycle
         endif
         if(xnetloc.gt.0.) then
            pumpmi(jloc,iloc)=pumpmi(jloc,iloc)+xnetloc
         endif
      end do
      close(13)
      write(*,*) nmi,' m&i recs read'

c output totals to plot files
      write(*,*) '..write mi plot file'
      open(8,file=chout//year//'migrid.dat',STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
      do i=1,ny
          do j=1,nx
              if(ibound(j,i).ne.0.and.pumpmi(j,i).gt.0.) then
                xj=j
                xloc=(xj-0.5)*gdx+xg0
                yj=ny-i+1
                yloc=(yj-0.5)*gdy+yg0
                node=nx*(i-1)+j          !node number (use to join data to grid in GIS) --spp
                write(8,*) xloc,yloc,pumpmi(j,i),i,j,node
c                if(icty(j,i).gt.22.or.icty(j,i).lt.9) then
c                  write(*,*) j,i,icty(j,i)
c                endif
              endif
          end do
      end do
      close(8)

c write out m&i pumping for the year
      open(8,file=chout//year//'.mi',STATUS='UNKNOWN')  !add subfolder path for output files chout='out/'
      suma=0.
      do i=1,ny
        do j=1,nx
          suma=suma+pumpmi(j,i)
        end do
        write(8,'(326f6.1)') (pumpmi(j,i),j=1,nx)
      end do
      close(8)

      write(9,*) 'm&i pumping'
      write(9,*) suma
      stop
      end
