C     Last change:  ERB  26 Jul 2002    4:24 pm
C     ******************************************************************
C     MAIN CODE FOR U.S. GEOLOGICAL SURVEY MODULAR MODEL -- MODFLOW
C           BY MICHAEL G. MCDONALD AND ARLEN W. HARBAUGH
C     MODFLOW-88 documented in:
C        McDonald, M.G. and Harbaugh, A.W., 1988, A modular three-
C           dimensional finite-difference ground-water flow model:
C           U.S. Geological Survey Techniques of Water Resources
C           Investigations, Book 6, Chapter A1, 586 p.
C     MODFLOW-96 documented in:
C        Harbaugh, A.W. and McDonald, M.G., 1996, User's documentation
C           for the U.S. Geological Survey modular finite-difference
C           ground-water flow model: U.S. Geological Survey Open-File
C           Report 96-485
C     MODFLOW-2000 documented in:
C        Harbaugh, A.W., Banta, E.R., Hill, M.C., and McDonald, M.G.,
C           2000, MODFLOW-2000, the U.S. Geological Survey modular
C           ground-water model--User guide to modularization concepts
C           and the Ground-Water Flow Process: U.S. Geological Survey
C           Open-File Report 00-92
C        Hill, M.C., Banta, E.R., Harbaugh, A.W., and Anderman, E.R.,
C           2000, MODFLOW-2000, the U.S. Geological Survey modular
C           ground-water model--User guide to the Observation,
C           Sensitivity, and Parameter-Estimation Processes and three
C           post-processing programs: U.S. Geological Survey Open-
C           File Report 00-184
C     ******************************************************************
C        SPECIFICATIONS:
C     ------------------------------------------------------------------
C-------ASSIGN VERSION NUMBER AND DATE
      CHARACTER*40 VERSION
      PARAMETER (VERSION='1.10 07/26/2002')
C
C-----DECLARE ARRAY TYPES
      REAL GX, X, RX, XHS
      DOUBLE PRECISION GZ, VAR, Z
      INTEGER IG, IX, IR
      CHARACTER*10 EQNAM, NIPRNAM
      CHARACTER*12 NAMES, OBSNAM
C
C *** FOR STATIC MEMORY ALLOCATION, THE FOLLOWING PARAMETER AND
C *** DIMENSION STATEMENTS MUST BE UNCOMMENTED.  TO CHANGE THE SIZE OF
C *** AN ARRAY, CHANGE THE VALUE OF THE CORRESPONDING (FORTRAN)
C *** PARAMETER AND RECOMPILE
C      PARAMETER (LENGX=1000000, LENIG=1000000, LENGZ=1000000,
C     &           LENX=2000000, LENIX=1500000, LENZ=1000000,
C     &           LENRX=1000000, LENIR=1000000, LENXHS=1000000,
C     &           NDD=10000, MPRD=100, IPRD=100)
C      DIMENSION GX(LENGX), IG(LENIG), X(LENX), IX(LENIX), RX(LENRX),
C     &          IR(LENIR), GZ(LENGZ), Z(LENZ), XHS(LENXHS),
C     &          EQNAM(MPRD), NIPRNAM(IPRD), NAMES(NDD+MPRD+IPRD),
C     &          OBSNAM(NDD)
C
C *** FOR STATIC MEMORY ALLOCATION, THE FOLLOWING ALLOCATABLE
C *** STATEMENT MUST BE COMMENTED OUT
      ALLOCATABLE GX(:), IG(:), X(:), IX(:), RX(:), IR(:), GZ(:), Z(:),
     &            XHS(:), NIPRNAM(:), EQNAM(:), NAMES(:), OBSNAM(:)
C
      PARAMETER (NIUNIT=100)
      PARAMETER (MXPER=8192)
C
      DIMENSION PERLEN(MXPER),NSTP(MXPER),TSMULT(MXPER),ISSFLG(MXPER)
      CHARACTER*16 VBNM(NIUNIT)
      DIMENSION VBVL(4,NIUNIT),IUNIT(NIUNIT),IREWND(NIUNIT)
      CHARACTER*80 HEADNG(2)
      DOUBLE PRECISION AP
C
C  UNCOMMENT "INCLUDE mpif.h" DURING TESTING TO DEVELOP MPI CODE IN THIS
C  ROUTINE OR TO ACTIVATE TIMERS AND DEBUG MODE.
C     INCLUDE 'mpif.h'
      INCLUDE 'parallel.inc'
      INCLUDE 'param.inc'
      INCLUDE 'openspec.inc'
C-------SPECIFY SIZE OF ARRAY TO HOLD SENSITIVITIES FROM ONE
C-------PARAMETER-ESTIMATION ITERATION TO THE NEXT WHEN PES, SEN, AND
C-------ANY OBS PACKAGE ARE ACTIVE.  IF IUHEAD IS GREATER THAN ZERO,
C-------LENXHS MAY EQUAL 1.  IF IUHEAD IS LESS THAN OR EQUAL TO ZERO,
C-------LENXHS MUST BE AT LEAST:
C-------NLAY*NCOL*NROW*(NUMBER OF PARAMETERS TO BE ESTIMATED).
C
      COMMON /BCFCOM/LAYCON(200)
      COMMON /DISCOM/LBOTM(200),LAYCBD(200)
      COMMON /LPFCOM/LAYTYP(200),LAYAVG(200),CHANI(200),LAYVKA(200),
     1               LAYWET(200)
      INTEGER LAYHDT(200)
C
      CHARACTER*4 PIDTMP
      CHARACTER*20 CHEDFM,CDDNFM,CBOUFM
      CHARACTER*200 FNAME, OUTNAM, COMLIN
C
      LOGICAL EXISTS, BEFIRST
      INTEGER NPEVT, NPGHB, NPDRN, NPHFB, NPRIV, NPSTR, NPWEL, NPRCH
      INTEGER IUBE(2), IBDT(8)
      CHARACTER*4 CUNIT(NIUNIT)
      CHARACTER*10 PARNEG(MXPAR)
      DATA CUNIT/'BCF6', 'WEL ', 'DRN ', 'RIV ', 'EVT ', '    ', 'GHB ',
     &           'RCH ', 'SIP ', 'DE4 ', 'SOR ', 'OC  ', 'PCG ', 'LMG ',
     &           '    ', 'FHB ', 'RES ', 'STR ', 'IBS ', 'CHD ', 'HFB6',
     &           'LAK ', 'LPF ', 'DIS ', 'SEN ', 'PES ', 'OBS ', 'HOB ',
     &           'ADV2', 'COB ', 'ZONE', 'MULT', 'DROB', 'RVOB', 'GBOB',
     &           'STOB', 'HUF ', 'CHOB', 'ETS ', 'DRT ', 'DTOB', '    ',
     &           'HYD ', '    ', 'SFOB', 'GAGE', '    ', '    ', 'LMT6',
     &           '    ', 50*'    '/
C     ------------------------------------------------------------------
      CALL PLL1IN
      IF (MYID.EQ.MPROC) WRITE (*,1) VERSION
    1 FORMAT (/,34X,'MODFLOW-2000',/,
     &4X,'U.S. GEOLOGICAL SURVEY MODULAR FINITE-DIFFERENCE',
     &' GROUND-WATER FLOW MODEL',/,29X,'Version ',A/)
      INUNIT = 99
      IBUNIT = 98
      IBOUTS = 97
      IERRU  = 96
      MAXUNIT= INUNIT
C     DEFINE RANGE OF RESERVED FILE UNITS
      MINRSV = 96
      MAXRSV = 99
      IBATCH = 0
CLAK
      NSOL = 1
      DUM=0.0D0
C
      INQUIRE (FILE='modflow.bf',EXIST=EXISTS)
      IF (EXISTS) THEN
        IBATCH = 1
        IF (MYID.EQ.MPROC) THEN
          OPEN (UNIT=IBUNIT,FILE='modflow.bf',STATUS='OLD')
          OPEN (UNIT=IBOUTS,FILE='modbatch.rpt')
          WRITE (IBOUTS,*) ' USGS MODFLOW MODEL BATCH-MODE REPORT'
        ENDIF
      ENDIF
C2------OPEN FILE OF FILE NAMES.
   10 CONTINUE
      IF (MYID.EQ.MPROC) THEN
        IF (IBATCH.GT.0) THEN
          READ (IBUNIT,'(A)',END=11) FNAME
          GOTO 12
   11     CLOSE(IBUNIT)
          CLOSE(IBOUTS)
          FNAME=' '
          GOTO 15
   12     IF (FNAME.EQ.' ') GOTO 10
          WRITE (IBOUTS,'(1X,/1X,A)') FNAME
        ELSE
          FNAME=' '
          COMLIN=' '
C *** Subroutines GETARG and GETCL are extensions to Fortran 90/95 that
C *** allow a program to retrieve command-line arguments.  To enable
C *** Modflow-2000 to read the name of a Name file from the command
C *** line, either GETARG or GETCL must be called, but not both.  As
C *** distributed, the call to GETARG is uncommented.  For compilers
C *** that support GETCL but not GETARG, comment out the call to GETARG
C *** and uncomment the call to GETCL.  The calls to both GETARG and
C *** GETCL may be commented out for compilers that do not support
C *** either extension.
          CALL GETARG(1,COMLIN)
C          CALL GETCL(COMLIN)
          ICOL = 1
          IF(COMLIN.NE.' ') THEN
            FNAME=COMLIN
          ELSE
            WRITE (*,*) ' Enter the name of the NAME FILE: '
            READ (*,'(A)') FNAME
            CALL URWORD(FNAME,ICOL,ISTART,ISTOP,0,N,R,0,0)
            FNAME=FNAME(ISTART:ISTOP)
          ENDIF
          IF (FNAME.EQ.' ') GOTO 15
          INQUIRE (FILE=FNAME,EXIST=EXISTS)
          IF(.NOT.EXISTS) THEN
            NC=INDEX(FNAME,' ')
            FNAME(NC:NC+3)='.nam'
            INQUIRE (FILE=FNAME,EXIST=EXISTS)
            IF(.NOT.EXISTS) THEN
              WRITE (*,480) FNAME(1:NC-1),FNAME(1:NC+3)
              FNAME=' '
            ENDIF
          ENDIF
        ENDIF
        IF (FNAME.EQ.' ') GOTO 15
        INQUIRE (FILE=FNAME,EXIST=EXISTS)
        IF (.NOT.EXISTS) THEN
          IF (IBATCH.GT.0) THEN
            WRITE (IBOUTS,*) ' Specified name file does not exist.'
            WRITE (IBOUTS,*) ' Processing will continue with the next ',
     &                       'name file in modflow.bf.'
          ENDIF
          GOTO 10
        ENDIF
      ENDIF
   15 CONTINUE
  480 FORMAT(1X,'Can''t find name file ',A,' or ',A)
C
C     BROADCAST FNAME AND OPEN FILE FOR WARNINGS AND ERROR MESSAGES
      CALL PLL1FN(FNAME)
      IF (FNAME.EQ.' ') GOTO 120
      CALL PLL1OP(IERRU,IERR)
      OPEN (UNIT=INUNIT,FILE=FNAME,STATUS='OLD',ACTION=ACTION(1))
      IF (MYID.EQ.MPROC) WRITE(*,490)' Using NAME file: ',FNAME
  490 FORMAT(A,A)
C
C  DEFINE (DF) PROCEDURE
      CALL GLO1BAS6DF(INUNIT,IUNIT,CUNIT,IREWND,NIUNIT,IOUTG,IOUT,
     &                VERSION,NCOL,NROW,NLAY,NPER,ITMUNI,ISUMGX,
     &                MXPER,ISUMIG,ISUMGZ,INBAS,LENUNI,ISUMX,ISUMZ,
     &                ISUMIX,LAYHDT,24,IFREFM,INAMLOC,IPRTIM,IBDT)
      CALL OBS1BAS6DF(IFLD,IOBS,IOSTAR,IOWTQ,IOWTQDR,IOWTQGB,
     &                IOWTQRV,IOWTQST,IQ1,IUNIT(27),JT,LCCOFF,LCHFB,
     &                LCIPLO,LCIPLP,LCIQOB,LCNDER,LCNQOB,LCOBADV,
     &                LCOBDRN,LCOBGHB,LCOBBAS,LCOBRIV,LCOBSE,LCOBSTR,
     &                LCQCLS,LCROFF,LCSSAD,LCSSCH,LCSSDR,LCSSGB,LCSSGF,
     &                LCSSPI,LCSSRV,LCSSST,LCSSTO,LCWT,LCWTQ,MOBS,NC,ND,
     &                NDMH,NDMHAR,NH,NOBADV,NQ,NQC,NQT,NQT1,NQTDR,
     &                NQTGB,NQTRV,NQTST,NQTCH,NT,NTT2,IOBSUM,LCX,
     &                LCBUF2,NDAR,LCOBDRT,LCSSDT,NQTDT,IOWTQDT,LCSSSF,
     &                NQTSF,LCOBSFR,IOWTQSF,NHT,LCRSQA,LCRSPA,LCBUF1,
     &                LCH,LCHOBS,LCWTQS,LCHANI,LCXND)
      CALL SEN1BAS6DF(ISENALL,ISEN,IPRINTS,IUNIT(25),LCB1,LCLN,LCSV,NPE,
     &                NPLIST,RCLOSE,IUHEAD,MXSEN,LCSNEW,IOUTG,LCBSCA)
      CALL PES1BAS6DF(IBEFLG,IFO,IOUB,IPES,IPR,IPRAR,IPRINT,ITERPF,
     &                ITERPK,ITMXP,IUNIT(26),IYCFLG,JMAX,LASTX,LCDMXA,
     &                LCNIPR,LCNPAR,LCPRM,LCWP,LCWTP,LCWTPS,LCW3,LCW4,
     &                MPR,MPRAR,NPNGAR,SOSC,SOSR,BEFIRST,LCBPRI,LCPARE,
     &                LCAMPA,LCAMCA,LCAAP)
C
C  GLOBAL ALLOCATE (AL) PROCEDURE
      CALL GLO1BAS6AL(IUNIT(24),NCNFBD,NBOTM,NCOL,NROW,NLAY,LCBOTM,
     &                LCDELR,LCDELC,ISUMGX,IOUTG,LCHNEW,LCIBOU,LCCR,
     &                LCCC,LCCV,LCRHS,LCHCOF,LCHOLD,LCBUFF,LCSTRT,
     &                ISUMGZ,ISUMIG,ISEN,IOBS,IPES,ISENALL,ITMXP,IPAR,
     &                IUNIT(31),IUNIT(32),NMLTAR,NZONAR,NML,NZN,LCRMLT,
     &                LCIZON,IUNIT(15))
C
C  DYNAMICALLY ALLOCATE GLOBAL ARRAYS GX, GZ, AND IG.  FOR STATIC
C  MEMORY ALLOCATION, THE FOLLOWING THREE ASSIGNMENT AND ONE ALLOCATE
C  STATEMENTS MUST BE COMMENTED OUT
      LENGX = ISUMGX - 1
      LENGZ = ISUMGZ - 1
      LENIG = ISUMIG - 1
      ALLOCATE (GX(LENGX),GZ(LENGZ),IG(LENIG))
C
      CALL MEMCHKG(ISUMGX,ISUMIG,ISUMGZ,LENGX,LENIG,LENGZ,IOUTG,IERR,
     &             IERRU)
      IF (IERR.GT.0) CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
C
C  GLOBAL READ AND PREPARE (RP) PROCEDURE
      CALL GLO1BAS6RP(IUNIT(24),NCOL,NROW,NLAY,GX(LCBOTM),NBOTM,IOUTG,
     1                GX(LCDELR),GX(LCDELC),NPER,PERLEN,NSTP,TSMULT,
     2                ISSFLG,ITRSS,IUNIT(31),IUNIT(32),NMLTAR,NZONAR,
     3                GX(LCRMLT),IG(LCIZON),NML,NZN)
C
C-----NO rewind AL and RP for Ground-Water Flow Process
      IF(IUNIT(23).GT.0)
     1    CALL GWF1LPF1AL(ISUMX,LCHK,LCVKA,LCSC1,LCSC2,LCHANI,LCVKCB,
     2                    IUNIT(23),NCOL,NROW,NLAY,IOUTG,ILPFCB,LCWETD,
     3                    HDRY,NPLPF,NCNFBD,LCLAYF,IREWND(23),ISUMIX,
     4                    LAYHDT,ITRSS,LCSV,ISEN)
      IF(IUNIT(37).GT.0)
     1    CALL GWF1HUF1AL(ISUMX,LCHK,LCVKA,LCSC1,IUNIT(37),ITRSS,NCOL,
     2                    NROW,NLAY,IOUTG,IHUFCB,LCWETD,HDRY,NPER,
     3                    ISSFLG,LCHGUF,IREWND(37),NHUF,NPHUF,
     4                    LCHUFTHK,LCHKCC,ISUMIX,IOHUF,LAYHDT,LCHUFTMP)
      IF(IUNIT(9).GT.0)
     1    CALL SIP5AL(ISUMX,ISUMIX,LCEL,LCFL,LCGL,LCV,LCHDCG,LCLRCH,LCW,
     2                MXITER,NPARM,NCOL,NROW,NLAY,IUNIT(9),IOUTG,IFREFM,
     3                IREWND(9))
      IF(IUNIT(10).GT.0)
     1    CALL DE45AL(ISUMX,ISUMIX,LCAU,LCAL,LCIUPP,LCIEQP,LCD4B,LCLRCH,
     2                LCHDCG,MXUP,MXLOW,MXEQ,MXBW,IUNIT(10),ITMX,ID4DIR,
     3                NCOL,NROW,NLAY,IOUTG,ID4DIM,IREWND(10))
      IF(IUNIT(11).GT.0)
     1    CALL SOR5AL(ISUMX,ISUMIX,LCA,LCRES,LCHDCG,LCLRCH,LCIEQP,
     2                MXITER,NCOL,NLAY,NSLICE,MBW,IUNIT(11),IOUTG,
     3                IFREFM,IREWND(11))
      IF(IUNIT(13).GT.0)
     1    CALL PCG2AL(ISUMX,ISUMIX,LCV,LCSS,LCP,LCCD,LCHCHG,LCLHCH,
     2                LCRCHG,LCLRCH,MXITER,ITER1,NCOL,NROW,NLAY,
     3                IUNIT(13),IOUTG,NPCOND,LCIT1,LCHCSV,IFREFM,
     4                IREWND(13),ISUMZ)
      IF(IUNIT(14).GT.0)
     1    CALL LMG1AL(ISUMZ,ISUMIX,LCA,LCIA,LCJA,LCU1,LCFRHS,
     2                LCIG,ISIZ1,ISIZ2,ISIZ3,ISIZ4,ICG,NCOL,NROW,NLAY,
     3                IUNIT(14),IOUTG,1)
C
C-----ALLOCATE SPACE FOR SENSITIVITY CALCULATIONS
      IF (ISEN.GT.0)
     &    CALL SEN1BAS6AL(ISUMX,ISUMIX,NCOL,NROW,NLAY,IOUTG,IUHEAD,
     &                    NPLIST,IUNIT(25),IPAR,LCHCLO,LCRCLO,LCLN,
     &                    IPRINTS,LCISEN,LCBU,LCBL,LCB1,ISENALL,
     &                    IREWND(25),LCSNEW,LCSOLD,ISUMZ,ISEN,ISENSU,
     &                    ISENPU,ISENFM,IPES,MXSEN,LCBSCA,ITMXP,MAXUNIT,
     &                    MINRSV,MAXRSV,NSTP,NPER,NTIMES,LCSEND,LCSNDT)
C-----ALLOCATE SPACE FOR PARAMETER-ESTIMATION PROCESS
      IF (IPES.GT.0)
     &    CALL PES1BAS6AL(ISUMX,ISUMZ,ISUMIX,IOUTG,NPLIST,LCC,LCSCLE,
     &                    LCG,LCDD,LCWP,MPR,LCPRM,LCPV,LCR,LCU,LCGD,
     &                    LCS,NOPT,IPR,LCWTP,LCWTPS,LCW3,LCW4,LCNIPR,
     &                    LCEIGL,LCEIGV,LCEIGW,LCIPNG,IUNIT(26),
     &                    NPNG,MPRAR,IPRAR,NPNGAR,IREWND(26),
     &                    LCPRNT,LCPARE,ITMXP,LCSSPI,LCSSTO,DMAX,TOL,
     &                    SOSC,IOSTAR,NFIT,SOSR,IPRC,IPRINT,LPRINT,CSA,
     &                    FCONV,LASTX,ISEN,IPES,IPAR,IBEFLG,IYCFLG,
     &                    LCDMXA,LCNPAR,LCBPRI,RMARM,IAP,LCAAP,
     &                    LCAMCA,LCAMPA,RMAR)
C-----READ INPUT RELATED TO ALL OBSERVATIONS AND OPEN
C     PARAMETER-VALUE FILE ON IOUB
      IF (IOBS.GT.0)
     &    CALL OBS1BAS6AL(IOUB,IOUTG,ISCALS,ISEN,IUNIT(27),OUTNAM,
     &                    ISOLDX,ISOLDZ,ISOLDI,ISUMX,ISUMZ,ISUMIX)
C-----ALLOCATE SPACE FOR HEAD OBSERVATIONS
      IF (IUNIT(28).GT.0)
     &    CALL OBS1BAS6HAL(IUNIT(28),NH,MOBS,MAXM,ISUMX,ISUMIX,LCNDER,
     &                     LCCOFF,LCROFF,LCIOFF,LCJOFF,LCRINT,LCMLAY,
     &                     LCPR,ND,IOUTG,IOBSUM,LCOBBAS,ITMXP,LCSSGF,
     &                     IOBS,NHT)
C-----ALLOCATE SPACE FOR FLOW OBSERVATIONS
      IF (IUNIT(33).GT.0)
     &    CALL OBS1DRN6AL(IUNIT(33),NQ,NQC,NQT,IOUTG,NQDR,NQTDR,IOBSUM,
     &                    LCOBDRN,ITMXP,LCSSDR,ISUMX,IOBS)
      IF (IUNIT(34).GT.0)
     &    CALL OBS1RIV6AL(IUNIT(34),NQ,NQC,NQT,IOUTG,NQRV,NQTRV,IOBSUM,
     &                    LCOBRIV,ITMXP,LCSSRV,ISUMX,IOBS)
      IF (IUNIT(35).GT.0)
     &    CALL OBS1GHB6AL(IUNIT(35),NQ,NQC,NQT,IOUTG,NQGB,NQTGB,IOBSUM,
     &                    LCOBGHB,ITMXP,LCSSGB,ISUMX,IOBS)
      IF (IUNIT(36).GT.0)
     &    CALL OBS1STR6AL(IUNIT(36),NQ,NQC,NQT,IOUTG,NQST,NQTST,IOBSUM,
     &                    LCOBSTR,ITMXP,LCSSST,ISUMX,IOBS)
      IF (IUNIT(38).GT.0)
     &    CALL OBS1BAS6FAL(IUNIT(38),NQ,NQC,NQT,IOUTG,NQCH,NQTCH,IOBSUM,
     &                     LCOBCHD,ITMXP,LCSSCH,ISUMX,IOBS)
      IF (IUNIT(41).GT.0)
     &    CALL OBS1DRT1AL(IUNIT(41),NQ,NQC,NQT,IOUTG,NQDT,NQTDT,IOBSUM,
     &                    LCOBDRT,ITMXP,LCSSDT,ISUMX,IOBS)
C-----ALLOCATE SPACE FOR ADVECTIVE TRAVEL OBSERVATIONS (ADV PACKAGE)
      IF (IUNIT(29).GT.0)
     &    CALL OBS1ADV2AL(IUNIT(29),NPTH,NTT2,IOUTT2,KTDIM,KTFLG,KTREV,
     &                    ADVSTP,IOUTG,LCICLS,LCPRST,LCTT2,LCPOFF,
     &                    LCNPNT,ND,ISUMX,ISUMIX,NROW,NCOL,NLAY,IUNIT,
     &                    NIUNIT,LCDRAI,MXDRN,NDRAIN,LCRIVR,MXRIVR,
     &                    LCBNDS,MXBND,NBOUND,LCIRCH,LCRECH,ICSTRM_,
     &                    LCSTRM_,MXSTRM,NSTREM,IOBSUM,LCOBADV,NOBADV,
     &                    ITMXP,LCSSAD,NDRNVL,NGHBVL,NRIVVL,NRIVER,IOBS,
     &                    FSNK,NBOTM,LCHANI,LCHKCC,
     &                    LCHUFTHK,NHUF,LCWELL,NWELVL,MXWELL,NWELLS)
C-----ALLOCATE SPACE FOR ALL OBSERVATIONS AND FOR RESIDUALS RELATED TO
C     OBSERVATIONS AND PRIOR INFORMATION. ALSO INITIALIZE SOME ARRAYS
      IF (IOBS.GT.0)
     &    CALL OBS1BAS6AC(EV,ISUMX,ISUMZ,ISUMIX,LCTOFF,NH,LCH,ND,
     &                    LCHOBS,LCWT,NDMH,NDMHAR,LCWTQ,LCWTQS,LCW1,
     &                    LCW2,LCX,NPLIST,LCXD,IPAR,IOUTG,IDRY,
     &                    JDRY,NQ,NQAR,NQC,NQCAR,NQT,NQTAR,NHAR,MOBS,
     &                    MOBSAR,LCIBT,LCNQOB,LCNQCL,LCIQOB,LCQCLS,
     &                    LCIPLO,LCIPLP,IPR,MPR,IPRAR,LCBUF1,LCSSTO,
     &                    ITMXP,LBUFF,LCOBSE,ISOLDX,ISOLDZ,ISOLDI,MXSEN,
     &                    LCBUF2,NDAR,NHT,LCRSQA,LCRSPA,LCXND)
C
C------DYNAMICALLY ALLOCATE X, Z, IX, XHS, NIPRNAM, EQNAM, NAMES, AND
C      OBSNAM ARRAYS FOR OBS, SEN, AND PES PROCESSES; SOLVERS; AND
C      PACKAGES THAT DO ALLOCATION ONCE ONLY.  FOR STATIC MEMORY
C      ALLOCATION, THE FOLLOWING LINES, THROUGH THE ALLOCATE STATEMENTS,
C      MUST BE COMMENTED OUT
      LENX = ISUMX - 1
      IF(LENX.LT.1) LENX=1
      LENZ = ISUMZ - 1
      IF(LENZ.LT.1) LENZ=1
      LENIX = ISUMIX - 1
      IF(LENIX.LT.1) LENIX=1
      IF (ISEN.NE.0 .AND. IUHEAD.LE.0 .AND. MXSEN.GT.0) THEN
        LENXHS = NCOL*NROW*NLAY*MXSEN
      ELSE
        LENXHS = 1
      ENDIF
      NDD = NDAR
      MPRD = MPRAR
      IPRD = IPRAR
      ALLOCATE (X(LENX),Z(LENZ),IX(LENIX),XHS(LENXHS))
      ALLOCATE (NIPRNAM(IPRAR),EQNAM(MPRAR),NAMES(ND+IPRAR+MPRAR),
     &          OBSNAM(NDAR))
C
C------IF THE ARRAYS ARE NOT BIG ENOUGH THEN STOP.
      CALL MEMCHK(ISUMX,ISUMIX,ISUMZ,LENX,LENIX,LENZ,IOUTG,ISEN,IUHEAD,
     &            LENXHS,NCOL,NROW,NLAY,MXSEN,IERR,IERRU,NDD,NDAR,MPRD,
     &            MPRAR,IPRD,IPRAR)
      IF (IERR.GT.0) CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
C
      IF (ISEN.GT.0 .OR. ISENALL.LT.0 .OR. IBEFLG.EQ.2)
     &    CALL SEN1BAS6RP(X(LCBL),X(LCBU),FAC,IX(LCISEN),IOUTG,
     &                    IUNIT(25),IX(LCLN),NPE,NPLIST,DETWTP,ISENALL,
     &                    X(LCBSCA),MXSEN)
      IF (IPES.GT.0 .OR. IBEFLG.EQ.2)
     &    CALL PES1BAS6RP(IUNIT(26),IOUTG,NPE,X(LCWP),IX(LCLN),DMAX,
     &                    Z(LCDD),FCONV,EV,MPR,X(LCPRM),IX(LCISEN),
     &                    NPLIST,X(LCWTP),X(LCWTPS),Z(LCW3),Z(LCW4),IPR,
     &                    IX(LCNIPR),DETWTP,ND,ADMX,AP,DMX,NIPRNAM,
     &                    EQNAM,MPRAR,IPRAR,IX(LCIPNG),NPNG,NPNGAR,
     &                    IX(LCIPLO),NAMES,PARNEG,MXPAR,LBUFF,FSTAT,
     &                    X(LCBPRI),IERR,IYCFLG,IX(LCNPAR),ITMXP,IBEFLG)
C
C-----INITIALIZE ARRAYS USED FOR OBSERVATION PROCESS
      IF (IOBS.GT.0) CALL OBS1BAS6RP(ND,NDAR,NDMH,NDMHAR,NQCAR,
     &                               X(LCQCLS),RSQO,RSQOO,RSQP,X(LCWT),
     &                               X(LCWTQ),X(LCWTQS))
C
C-----READ AND PREPARE INFORMATION FOR OBSERVATIONS
C
C-----READ HEAD OBSERVATION DATA
      IF (IUNIT(28).GT.0)
     &    CALL OBS1BAS6HRP(NCOL,NROW,NLAY,NPER,IUNIT(28),IOUTG,OBSNAM,
     &                    NH,IX(LCNDER),JT,IX(LCJOFF),IX(LCIOFF),
     &                    X(LCHOBS),X(LCWT),GX(LCDELR),GX(LCDELC),
     &                    X(LCRINT),X(LCCOFF),X(LCROFF),IX(LCMLAY),
     &                    X(LCPR),MOBS,IERR,X(LCTOFF),EV,EVH,MAXM,NSTP,
     &                    PERLEN,TSMULT,ISSFLG,ITRSS,NHAR,MOBSAR,
     &                    IX(LCIPLO),NAMES,ND,IPR,MPR)
C-----READ HEAD-DEPENDENT-BOUNDARY FLOW-OBSERVATION DATA
      IF (IUNIT(33).GT.0)
     &    CALL OBS1DRN6RP(NCOL,NROW,NPER,IUNIT(33),IOUTG,OBSNAM,NHT,JT,
     &                    IX(LCIBT),IX(LCNQOB),IX(LCNQCL),
     &                    IX(LCIQOB),X(LCQCLS),IERR,X(LCHOBS),X(LCTOFF),
     &                    X(LCWTQ),IOWTQ,IPRN,NDMH,NSTP,PERLEN,
     &                    TSMULT,ISSFLG,ITRSS,NQAR,NQCAR,
     &                    NQTAR,IQ1,NQT1,NDD,IUNIT(3),NQDR,NQTDR,NT,
     &                    NC,IX(LCIPLO),NAMES,ND,IPR,MPR,IOWTQDR)
      IF (IUNIT(34).GT.0)
     &    CALL OBS1RIV6RP(NCOL,NROW,NPER,IUNIT(34),IOUTG,OBSNAM,
     &                    NH,JT,IX(LCIBT),IX(LCNQOB),
     &                    IX(LCNQCL),IX(LCIQOB),X(LCQCLS),IERR,
     &                    X(LCHOBS),X(LCTOFF),X(LCWTQ),IOWTQ,IPRN,
     &                    NDMH,NSTP,PERLEN,TSMULT,
     &                    ISSFLG,ITRSS,NQAR,NQCAR,NQTAR,IQ1,NQT1,
     &                    NDD,IUNIT(4),NQRV,NQTRV,NT,NC,IX(LCIPLO),
     &                    NAMES,ND,IPR,MPR,IOWTQRV)
      IF (IUNIT(35).GT.0)
     &    CALL OBS1GHB6RP(NCOL,NROW,NPER,IUNIT(35),IOUTG,OBSNAM,
     &                    NHT,JT,IX(LCIBT),IX(LCNQOB),
     &                    IX(LCNQCL),IX(LCIQOB),X(LCQCLS),IERR,
     &                    X(LCHOBS),X(LCTOFF),X(LCWTQ),IOWTQ,IPRN,
     &                    NDMH,NSTP,PERLEN,TSMULT,
     &                    ISSFLG,ITRSS,NQAR,NQCAR,NQTAR,IQ1,NQT1,
     &                    NDD,IUNIT(7),NQGB,NQTGB,NT,NC,IX(LCIPLO),
     &                    NAMES,ND,IPR,MPR,IOWTQGB)
      IF (IUNIT(36).GT.0)
     &    CALL OBS1STR6RP(NPER,IUNIT(36),IOUTG,OBSNAM,NHT,JT,
     &                    IX(LCIBT),IX(LCNQOB),IX(LCNQCL),IX(LCIQOB),
     &                    X(LCQCLS),IERR,X(LCHOBS),X(LCTOFF),X(LCWTQ),
     &                    IOWTQ,IPRN,NDMH,NSTP,PERLEN,TSMULT,ISSFLG,
     &                    ITRSS,NQAR,NQCAR,NQTAR,IQ1,NQT1,IUNIT(18),
     &                    NQST,NQTST,NT,NC,IX(LCIPLO),NAMES,ND,IPR,
     &                    MPR,IOWTQST)
      IF (IUNIT(38).GT.0)
     &    CALL OBS1BAS6FRP(NCOL,NROW,NPER,IUNIT(38),IOUTG,OBSNAM,
     &                     NHT,JT,IX(LCIBT),IX(LCNQOB),
     &                     IX(LCNQCL),IX(LCIQOB),X(LCQCLS),IERR,
     &                     X(LCHOBS),X(LCTOFF),X(LCWTQ),IOWTQ,IPRN,
     &                     NDMH,NSTP,PERLEN,TSMULT,ISSFLG,ITRSS,NQAR,
     &                     NQCAR,NQTAR,IQ1,NQT1,NDD,NQCH,NQTCH,NT,NC,
     &                     IX(LCIPLO),NAMES,ND,IPR,MPR,IOWTQCH,NLAY)
      IF (IUNIT(41).GT.0)
     &    CALL OBS1DRT1RP(NCOL,NROW,NPER,IUNIT(41),IOUTG,OBSNAM,NHT,JT,
     &                    IX(LCIBT),IX(LCNQOB),IX(LCNQCL),
     &                    IX(LCIQOB),X(LCQCLS),IERR,X(LCHOBS),X(LCTOFF),
     &                    X(LCWTQ),IOWTQ,IPRN,NDMH,NSTP,PERLEN,
     &                    TSMULT,ISSFLG,ITRSS,NQAR,NQCAR,
     &                    NQTAR,IQ1,NQT1,NDD,IUNIT(40),NQDT,NQTDT,NT,
     &                    NC,IX(LCIPLO),NAMES,ND,IPR,MPR,IOWTQDT)
C
C-----READ ADVECTIVE-TRANSPORT DATA
      IF (IUNIT(29).GT.0)
     &    CALL OBS1ADV2RP(IOUTG,NROW,NCOL,NLAY,X(LCPRST),NPTH,
     &                    IX(LCNPNT),NTT2,NHT,NQT,OBSNAM,IX(LCICLS),
     &                    X(LCPOFF),X(LCTT2),X(LCHOBS),GX(LCDELR),
     &                    GX(LCDELC),X(LCWTQ),ND,KTDIM,IUNIT(29),NDMH,
     &                    IOWTQ,GX(LCBOTM),NBOTM,IX(LCIPLO),NAMES,IPR,
     &                    MPR,JT)
C-----CHECK OBSERVATION DATA AGAINST ALLOCATED STORAGE
      IF (IOBS.GT.0) CALL OBS1BAS6CK(NC,NQC,NT,NQT,IOUTG)
C-----CHECK FOR ERRORS, CALCULATE THE WEIGHT MATRIX AND ITS SQUARE-ROOT
      IF (IPAR.GE.-1)
     &    CALL OBS1BAS6QM(NDMH,X(LCWTQ),X(LCWTQS),DTLWTQ,Z(LCW1),
     &                    Z(LCW2),EV,IOWTQ,IPRN,IOUTG,NDMHAR)
C
C---------SOLVER PACKAGE
      IF(IUNIT(9).GT.0)
     1    CALL SIP5RP(NPARM,MXITER,ACCL,HCLOSE,X(LCW),IUNIT(9),IPCALC,
     2                IPRSIP,IOUTG,IFREFM)
      IF(IUNIT(10).GT.0)
     1    CALL DE45RP(IUNIT(10),MXITER,NITER,ITMX,ACCL,HCLOSE,IFREQ,
     2                IPRD4,IOUTG,MUTD4)
      IF(IUNIT(11).GT.0)
     1    CALL SOR5RP(MXITER,ACCL,HCLOSE,IUNIT(11),IPRSOR,IOUTG,IFREFM)
      IF(IUNIT(13).GT.0)
     1    CALL PCG2RP(MXITER,ITER1,HCLOSE,RCLOSE,NPCOND,NBPOL,RELAX,
     2                IPRPCG,IUNIT(13),IOUTG,MUTPCG,NITER,DAMP,IFREFM)
      IF(IUNIT(14).GT.0)
     1    CALL LMG1RP(IUNIT(14),MXITER,MXCYC,BCLOSE,DAMP,IOUTAMG,IOUTG,
     2                1,ICG,IADAMP,DUP,DLOW,HCLOSE)
C-----CHECK DATA AND CALCULATE CONVERGENCE CRITERIA FOR SENSITIVITIES
      IF (ISEN.GT.0)
     &    CALL SEN1BAS6MS(JT,IOUTG,IX(LCLN),X(LCB1),IERR,NPER,X(LCHCLO),
     &                    X(LCRCLO),HCLOSE,RCLOSE,IPAR,NPE,NPLIST,
     &                    IX(LCISEN),NSTP,PERLEN,TSMULT,IUNIT(10))
C
C-----READ AND PREPARE FOR PACKAGES WITH NO REWIND
      IF(IUNIT(23).GT.0)
     1    CALL GWF1LPF1RQ(X(LCHK),X(LCVKA),X(LCVKCB),X(LCHANI),X(LCSC1),
     2                    X(LCSC2),IUNIT(23),ITRSS,NCOL,NROW,NLAY,
     3                    IOUTG,X(LCWETD),NPLPF,WETFCT,IWETIT,IHDWET,
     4                    IX(LCLAYF),GX(LCBOTM),NBOTM,GX(LCDELR),
     5                    GX(LCDELC),1,INAMLOC)
      IF(IUNIT(37).GT.0)
     1    CALL GWF1HUF1RQ(IUNIT(37),NCOL,NROW,NLAY,IOUTG,X(LCWETD),
     2                    WETFCT,IWETIT,IHDWET,IX(LCHGUF),1,NHUF,NPHUF,
     3                    X(LCHUFTHK),ITRSS)
C
C-------BEGIN ITERATION LOOP FOR PARAMETER ESTIMATION
      DO 105, KITP = 1,ITMXP
        ITERP = KITP
C       CHECK FOR PARAMETER VALUES <= 0 THAT SHOULD BE > 0.  CHANGE
C       PARAMETER VALUES AS NEEDED.
        IF (IPES.GT.0)
     &      CALL PES1BAS6CN(X(LCB1),IOUTG,IX(LCIPNG),ITERP,IX(LCLN),NPE,
     &                      NPLIST,NPNG,NPNGAR)
C
C-------SET SENSITIVITY ARRAYS TO ZERO AND STORE ON DISK OR IN MEMORY
        IF (ISEN.GT.0) CALL SEN1BAS6ZS(IUHEAD,LENXHS,NCOL,NPE,NROW,NLAY,
     &                                 Z(LCSNEW),X(LCSOLD),XHS,
     &                                 X(LCSEND),NTIMES)
C-------LOOP TO HERE WHEN CONVERGENCE HAS BEEN ACHIEVED BY TOL CRITERION
 20     CONTINUE
        ITERPK = ITERPK + 1
        ICNVGP = 1
        IF (IPAR.GT.-3) THEN
C-------IF PARAMETER ESTIMATION HAS CONVERGED, SET ITERPF TO
C       CALCULATE HEAD WITH THE NEW PARAMETERS AND THEN STOP
          IF (IFO.GT.0) THEN
            ITERPF = ITERP
          ENDIF
C---------REWIND INPUT FILES
          IF (ITERPK.GT.1)
     1        CALL PES1BAS6RW(INUNIT,FNAME,CUNIT,IREWND,NIUNIT,IOUT,
     2                        IOUTG,VERSION,IX(LCISEN),ITERP,ITERPF,
     3                        LASTX,NPLIST,ITERPK)
        ENDIF
C
C-------INITIALIZE H AND X ARRAYS, AND UNFLAG OMITTED OBSERVATIONS
        IF (IOBS.GT.0) CALL OBS1BAS6FM(X(LCH),ND,NDAR,NDMH,NDMHAR,
     &                                 X(LCWT),X(LCWTQ))
        IF (ISEN.GT.0 .AND. ITERPF.EQ.0) CALL OBS1BAS6DR(ND,NPE,X(LCX))
C4------ALLOCATE SPACE IN RX AND IR ARRAYS.
        CALL GWF1BAS6AL(HEADNG,NPER,TOTIM,NCOL,NROW,NLAY,NODES,INBAS,
     1                  IOUT,IXSEC,ICHFLG,IFREFM,ISUMRX,ISUMIR,LCIOFL,
     2                  ISTRT,IAPART)
        IF(IUNIT(1).GT.0)
     1      CALL GWF1BCF6AL(ISUMRX,LCSC1,LCHY,LCSC2,LCTRPY,ITRSS,ISS,
     2                      IUNIT(1),NCOL,NROW,NLAY,IOUT,IBCFCB,LCWETD,
     3                      IWDFLG,LCCVWD,WETFCT,IWETIT,IHDWET,HDRY,
     4                      IAPART,IFREFM,LAYHDT)
        IF(IUNIT(2).GT.0)
     1      CALL GWF1WEL6AL(ISUMRX,LCWELL,MXWELL,NWELLS,IUNIT(2),IOUT,
     2                      IWELCB,NWELVL,IWELAL,IFREFM,NPWEL,IPWBEG,
     3                      NNPWEL,NOPRWL)
        IF(IUNIT(3).GT.0)
     1      CALL GWF1DRN6AL(ISUMRX,LCDRAI,MXDRN,NDRAIN,IUNIT(3),IOUT,
     2                      IDRNCB,NDRNVL,IDRNAL,IFREFM,NPDRN,IDRNPB,
     3                      NNPDRN,NOPRDR)
        IF(IUNIT(4).GT.0)
     1      CALL GWF1RIV6AL(ISUMRX,LCRIVR,MXRIVR,NRIVER,IUNIT(4),IOUT,
     2                      IRIVCB,NRIVVL,IRIVAL,IFREFM,NPRIV,IRIVPB,
     3                      NNPRIV,NOPRRV)
        IF(IUNIT(5).GT.0)
     1      CALL GWF1EVT6AL(ISUMRX,ISUMIR,LCIEVT,LCEVTR,LCEXDP,LCSURF,
     2                      NCOL,NROW,NEVTOP,IUNIT(5),IOUT,IEVTCB,
     3                      IFREFM,NPEVT,IEVTPF)
        IF(IUNIT(7).GT.0)
     1      CALL GWF1GHB6AL(ISUMRX,LCBNDS,MXBND,NBOUND,IUNIT(7),IOUT,
     2                      IGHBCB,NGHBVL,IGHBAL,IFREFM,NPGHB,IGHBPB,
     3                      NNPGHB,NOPRGB)
        IF(IUNIT(8).GT.0)
     1      CALL GWF1RCH6AL(ISUMRX,ISUMIR,LCIRCH,LCRECH,NRCHOP,NCOL,
     2                      NROW,IUNIT(8),IOUT,IRCHCB,IFREFM,NPRCH,
     3                      IRCHPF)
        IF(IUNIT(16).GT.0)
     1      CALL FHB1AL(ISUMRX,ISUMIR,LCFLLC,LCBDTM,LCFLRT,LCBDFV,
     2                  LCBDHV,LCHDLC,LCSBHD,NBDTIM,NFLW,NHED,IUNIT(16),
     3                  IOUT,IFHBCB,NFHBX1,NFHBX2,IFHBD3,IFHBD4,IFHBD5,
     4                  IFHBSS,ISS,NHEDDIM,NFLWDIM,NBDHVDIM)
        IF(IUNIT(18).GT.0)
     1      CALL GWF1STR6AL(ISUMRX,ISUMIR,LCSTRM_,ICSTRM_,MXSTRM,NSTREM,
     2                  IUNIT(18),IOUT,ISTCB1STR6,ISTCB2STR6,NSSSTR6,
     3                  NTRIB,NDIV,ICALC,CONSTSTR6,LCTBAR,LCTRIB,
     4                  LCIVAR_,LCFGAR,NPSTR,ISTRPB)
        IF(IUNIT(19).GT.0)
     1      CALL GWF1IBS6AL(ISUMRX,LCHC,LCSCE,LCSCV,LCSUB,NCOL,
     2                  NROW,NLAY,IIBSCB,IIBSOC,IUNIT(19),IOUT,IBSDIM)
        IF(IUNIT(20).GT.0)
     1      CALL GWF1CHD6AL(ISUMRX,LCCHDS,NCHDS,MXCHD,IUNIT(20),IOUT,
     2                      NCHDVL,IFREFM,NPCHD,IPCBEG,NNPCHD,NOPRCH)
        IF (IUNIT(17).GT.0)
     &      CALL RES1AL(ISUMRX,LCIRES,LCIRSL,LCBRES,LCCRES,LCBBRE,
     &                  LCHRES,LCHRSE,IUNIT(17),IOUT,NRES,IRESCB,NRESOP,
     &                  IRESPT,NPTS,NCOL,NROW,ISUMIR)
        IF (IUNIT(21).GT.0)
     &      CALL GWF1HFB6AL(IUNIT(21),IOUT,ISUMRX,LCHFB,MXACTFB,NHFBNP,
     &                      NPHFB,MXHFB,IHFB,NOPRHB)
CLAK
        IF(IUNIT(22).GT.0)
     1               CALL LAK3AL(ISUMRX,ISUMIR,LCCOND,ICLAKE,MXLKND,
     2     LKNODE,LCSTAG,IUNIT(22),IOUT,ILKCB,NLAKES,INTRB,
     3     INDV,LCCNDF,LCLKPR,LCLKEV,ISTGLD,ISTGNW,IICS,IISUB,ISILL,
     4     LCWTDR,IFREFM,NROW,NCOL,NLAY,IBNLK,ILKBL,LKACC1,LKACC2,
     5     LKACC3,LKACC4,LKACC5,LKACC6,LKACC7,LKACC8,LKACC9,LKACC10,
     6     LKACC11,LKDRY,IBTMS,LKNCNT,LKKSUB,LKSADJ,LKFLXI,LKNCNS,LKSVT,
     7     LKJCLS,THETA,LCRNF,ITRSS,NSSITR,SSCNCR,LKSSMN,LKSSMX,LKNCN,
     8     LKDSR,LKCNN,LKCHN,IAREN,IUNIT(44),LSOVOL,NSS,IUNIT(15),
     9     LSLAKE,LSPPT,LSRNF,LSAUG,NSOL,IMSUB,IMSUB1,LSCGWL,LSSLAK,
     *     LSSWIN,LSSWOT,LSSPPT,LSCDRW,LSSRUN,
     *     LSGWIN,LSGWOT,LSLKSM,LSKLK,LSDONE,LSFLOB,LSRTCO,LSCLKO,
     *     LSALKI,LSALKO,ISTRIN,ISTROT,LKLMRR,IDSTRT,
     *     LKVI,ISTGLD2,LKCLKI,
     *     LKCUM1,LKCUM2,LKCUM3,LKCUM4,LKCUM5,
     *     LKCUM6,LKCUM7,LKCUM8,LKCUM9)
CLAK
        CALL GAGE5AL(IUNIT(46),ISUMIR,LSGAGE,NUMGAGE,IOUT,
     &                IUNIT(44),IUNIT(22),LKACC7,LCSTAG,LSLAKE,ICSTRM,
     &                NSTRM,NLAKES)
        IF(IUNIT(39).GT.0)
     &      CALL GWF1ETS1AL(ISUMRX,ISUMIR,LCIETS,LCETSR,LCETSX,LCETSS,
     &                      NCOL,NROW,NETSOP,IUNIT(39),IOUT,IETSCB,
     &                      IFREFM,NPETS,IETSPF,NETSEG,LCPXDP,LCPETM,
     &                      NSEGAR)
        IF(IUNIT(40).GT.0)
     &      CALL GWF1DRT1AL(ISUMRX,LCDRTF,MXDRT,NDRTCL,IUNIT(40),IOUT,
     &                      IDRTCB,NDRTVL,IDRTAL,IFREFM,NPDRT,IDRTPB,
     &                      NDRTNP,IDRTFL,NOPRDT)
        IF (IUNIT(43).GT.0)
     &      CALL HYD1BAS6AL(ISUMRX,LCHYDM,NHYDM,IHYDMUN,HYDNOH,
     &                      IUNIT(43),IOUT)
C
C------DYNAMICALLY ALLOCATE RX AND IR ARRAYS FOR PACKAGES THAT DO
C      ALLOCATION EVERY PARAMETER-ESTIMATION ITERATION.  FOR STATIC
C      MEMORY ALLOCATION, THE FOLLOWING IF...THEN BLOCK MUST BE
C      COMMENTED OUT
       IF (ITERPK.EQ.1) THEN
         LENRX = ISUMRX - 1
         IF(LENRX.LE.0) LENRX=1
         LENIR = ISUMIR - 1
         IF(LENIR.LE.0) LENIR=1
         ALLOCATE (RX(LENRX),IR(LENIR))
       ENDIF
C
C5------IF THE ARRAYS ARE NOT BIG ENOUGH THEN STOP.
        CALL MEMCHKR(ISUMRX,ISUMIR,LENRX,LENIR,IOUT,IERR,IERRU)
        IF (IERR.GT.0) CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
C
C6------READ AND PREPARE INFORMATION FOR ENTIRE SIMULATION.
C---------BASIC PACKAGE
        CALL GWF1BAS6RP(IG(LCIBOU),GZ(LCHNEW),GX(LCSTRT),INBAS,
     1                  HEADNG,NCOL,NROW,NLAY,VBVL,IR(LCIOFL),IUNIT(12),
     2                  IHEDFM,IDDNFM,IHEDUN,IDDNUN,IOUT,IPEROC,ITSOC,
     3                  CHEDFM,CDDNFM,IBDOPT,IXSEC,LBHDSV,LBDDSV,IFREFM,
     4                  IBOUUN,LBBOSV,CBOUFM,HNOFLO,NIUNIT,ITS,IAUXSV)
        IF(IUNIT(1).GT.0)
     1      CALL GWF1BCF6RP(IG(LCIBOU),GZ(LCHNEW),RX(LCSC1),RX(LCHY),
     2                      GX(LCCR),GX(LCCC),GX(LCCV),GX(LCDELR),
     3                      GX(LCDELC),RX(LCSC2),RX(LCTRPY),IUNIT(1),
     4                      ISS,NCOL,NROW,NLAY,IOUT,RX(LCWETD),IWDFLG,
     5                      RX(LCCVWD))
C-------SUBSTITUTE AND PREPARE FOR PACKAGES WITH NO REWIND
        IF(IUNIT(23).GT.0)
     1      CALL GWF1LPF1SP(IG(LCIBOU),GZ(LCHNEW),GX(LCCR),GX(LCCC),
     2                      GX(LCCV),GX(LCDELR),GX(LCDELC),GX(LCBOTM),
     3                      X(LCHK),X(LCVKA),X(LCVKCB),X(LCHANI),
     4                      X(LCSC1),X(LCSC2),ITRSS,NCOL,NROW,NLAY,IOUT,
     5                      X(LCWETD),NPLPF,NBOTM,GX(LCRMLT),IG(LCIZON),
     6                      NMLTAR,NZONAR,IX(LCLAYF),GX(LCBUFF),ITERPK)
        IF(IUNIT(37).GT.0)
     1      CALL GWF1HUF1SP(IG(LCIBOU),GZ(LCHNEW),GX(LCCR),GX(LCCC),
     2                      GX(LCCV),GX(LCDELR),GX(LCDELC),GX(LCBOTM),
     3                      X(LCHK),X(LCVKA),X(LCSC1),ITRSS,NCOL,NROW,
     4                      NLAY,IOUT,X(LCWETD),NHUF,NBOTM,GX(LCRMLT),
     5                      IG(LCIZON),NMLTAR,NZONAR,X(LCHUFTHK),
     6                      X(LCHKCC),HDRY,0,0,0,IX(LCHGUF),X(LCHUFTMP),
     7                      IWETIT,IHDWET,WETFCT)
C---------FLOW-SIMULATION OPTIONS
        IF(IUNIT(2).GT.0)
     1      CALL GWF1WEL6RQ(IUNIT(2),IOUTG,NWELVL,IWELAL,NCOL,NROW,NLAY,
     2                      NPWEL,RX(LCWELL),IPWBEG,MXWELL,IFREFM,
     3                      ITERPK,INAMLOC,NOPRWL)
        IF(IUNIT(3).GT.0)
     1      CALL GWF1DRN6RQ(IUNIT(3),IOUTG,NDRNVL,IDRNAL,NCOL,NROW,NLAY,
     2                      NPDRN,RX(LCDRAI),IDRNPB,MXDRN,IFREFM,ITERPK,
     &                      INAMLOC,NOPRDR)
        IF(IUNIT(4).GT.0)
     1      CALL GWF1RIV6RQ(IUNIT(4),IOUTG,NRIVVL,IRIVAL,NCOL,NROW,NLAY,
     2                      NPRIV,RX(LCRIVR),IRIVPB,MXRIVR,IFREFM,
     3                      ITERPK,INAMLOC,NOPRRV)
        IF(IUNIT(5).GT.0)
     &      CALL GWF1EVT6RQ(IUNIT(5),IOUTG,NPEVT,ITERPK,INAMLOC)
        IF(IUNIT(7).GT.0)
     1      CALL GWF1GHB6RQ(IUNIT(7),IOUTG,NGHBVL,IGHBAL,NCOL,NROW,NLAY,
     2                      NPGHB,RX(LCBNDS),IGHBPB,MXBND,IFREFM,ITERPK,
     &                      INAMLOC,NOPRGB)
        IF(IUNIT(8).GT.0)
     &      CALL GWF1RCH6RQ(IUNIT(8),IOUTG,NPRCH,ITERPK,INAMLOC)
        IF(IUNIT(16).GT.0)
     &      CALL FHB1RP(IG(LCIBOU),NROW,NCOL,NLAY,IR(LCFLLC),RX(LCBDTM),
     &                  NBDTIM,RX(LCFLRT),NFLW,NHED,IR(LCHDLC),
     &                  RX(LCSBHD),IUNIT(16),IOUT, NFHBX1,NFHBX2,IFHBD3,
     &                  IFHBD5,NHEDDIM,NFLWDIM)
        IF(IUNIT(18).GT.0)
     1      CALL GWF1STR6RQ(IUNIT(18),IOUTG,NCOL,NROW,NLAY,NPSTR,
     2                  RX(LCSTRM_),IR(ICSTRM_),ISTRPB,MXSTRM,ITERPK,
     &                  INAMLOC)
        IF(IUNIT(19).GT.0)
     1      CALL GWF1IBS6RP(GX(LCDELR),GX(LCDELC),GZ(LCHNEW),RX(LCHC),
     2                  RX(LCSCE),RX(LCSCV),RX(LCSUB),NCOL,NROW,
     3                  NLAY,NODES,IIBSOC,ISUBFM,ICOMFM,IHCFM,
     4                  ISUBUN,ICOMUN,IHCUN,IUNIT(19),IOUT,IBSDIM)
        IF(IUNIT(20).GT.0)
     1      CALL GWF1CHD6RQ(IUNIT(20),IOUTG,NCHDVL,NCOL,NROW,NLAY,NPCHD,
     2                      RX(LCCHDS),IPCBEG,MXCHD,IFREFM,ITERPK,
     &                      INAMLOC,NOPRCH)
C
        IF (IUNIT(21).GT.0)
     &      CALL GWF1HFB6RP(GX(LCBOTM),GX(LCCR),GX(LCCC),GX(LCDELR),
     &                      GX(LCDELC),RX(LCHFB),IUNIT(21),MXACTFB,
     &                      NBOTM,NCOL,NROW,NLAY,NODES,NHFBNP,NHFB,
     &                      NPHFB,IOUT,IOUTG,ITERPK,MXHFB,IHFB,LAYHDT,
     &                      INAMLOC,NOPRHB)
        IF(IUNIT(39).GT.0)
     &      CALL GWF1ETS1RQ(IUNIT(39),IOUTG,NPETS,ITERPK,INAMLOC)
        IF(IUNIT(40).GT.0)
     &      CALL GWF1DRT1RQ(IUNIT(40),IOUTG,NDRTVL,IDRTAL,NCOL,NROW,
     &                      NLAY,NPDRT,RX(LCDRTF),IDRTPB,MXDRT,IFREFM,
     &                      ITERPK,IDRTFL,INAMLOC,NOPRDT)
CLAK
C  REVISED IF STATEMENT
C       IF(IUNIT(46).GT.0.AND.(IUNIT(44).GT.0.OR.IUNIT(22).GT.0))
        IF(IUNIT(46).GT.0)
     &      CALL GAGE5RP(IR(LSGAGE),NUMGAGE,IOUT,IUNIT(46))
C
C-------CHECK THAT PARAMETER DEFINITIONS ARE COMPLETE
        IF (ITERPK.EQ.1) CALL GLO1BAS6CK(IOUTG,NPLIST)
        IF ((ISEN.GT.0 .OR. IBEFLG.EQ.2) .AND. ITERPK.EQ.1)
     &      CALL SEN1BAS6CP(IOUTG,NPLIST,ISENSU,CHEDFM)
        IF (IPES.GT.0)
     &      CALL PES1BAS6CK(X(LCBL),X(LCBU),IX(LCISEN),IOUB,IOUTG,
     &                      IX(LCIPNG),IX(LCLN),NPNG,NPLIST,NPNGAR,
     &                      ITERPK,FAC,FCONV,AP,ADMX,TOL,LAYHDT,NLAY,
     &                      X(LCBSCA),X(LCPARE),ITMXP)
        IF (IUNIT(43).GT.0)
     &      CALL HYD1BAS6RP(RX(LCHYDM),GX(LCSTRT),NHYDM,NUMH,
     &                      GX(LCDELR),GX(LCDELC),NCOL,NROW,NLAY,
     &                      LCHNEW,LCIBOU,IUNIT(43),IOUT)
        IF(IUNIT(43).GT.0 .AND. IUNIT(19).GT.0)
     &      CALL HYD1IBS2RP(RX(LCHYDM),NHYDM,NUMH,GX(LCDELR),
     &                      GX(LCDELC),NCOL,NROW,NLAY,LCIBOU,LCSUB,
     &                      LCHC,IUNIT(43),IOUT)
C
C7------SIMULATE EACH STRESS PERIOD.
        DO 100 KPER = 1, NPER
          KKPER = KPER
          CALL GWF1BAS6ST(NSTP(KKPER),DELT,TSMULT(KKPER),PERTIM,KKPER,
     &                    IOUT,PERLEN(KKPER))
          IF(IUNIT(19).GT.0)
     1        CALL GWF1IBS6ST(ISSFLG,KKPER,GZ(LCHNEW),RX(LCHC),NCOL,
     2              NROW,NLAY,IBSDIM,IOUT)
C
C7B-----READ AND PREPARE INFORMATION FOR STRESS PERIOD.
C----------READ USING PACKAGE READ AND PREPARE MODULES.
          IF(IUNIT(2).GT.0)
     &        CALL GWF1WEL6RP(RX(LCWELL),NWELLS,MXWELL,IUNIT(2),
     1                        IOUT,NWELVL,IWELAL,IFREFM,NCOL,NROW,NLAY,
     2                        NNPWEL,NPWEL,IPWBEG,NOPRWL)
          IF(IUNIT(3).GT.0)
     &        CALL GWF1DRN6RP(RX(LCDRAI),NDRAIN,MXDRN,IUNIT(3),
     1                        IOUT,NDRNVL,IDRNAL,IFREFM,NCOL,NROW,NLAY,
     2                        NNPDRN,NPDRN,IDRNPB,NOPRDR)
          IF(IUNIT(4).GT.0)
     &        CALL GWF1RIV6RP(RX(LCRIVR),NRIVER,MXRIVR,IUNIT(4),IOUT,
     1                        NRIVVL,IRIVAL,IFREFM,NCOL,NROW,NLAY,
     2                        NNPRIV,NPRIV,IRIVPB,NOPRRV)
          IF(IUNIT(5).GT.0)
     &        CALL GWF1EVT6RP(NEVTOP,IR(LCIEVT),RX(LCEVTR),RX(LCEXDP),
     1                        RX(LCSURF),GX(LCDELR),GX(LCDELC),NCOL,
     2                        NROW,IUNIT(5),IOUT,IFREFM,NPEVT,
     3                        GX(LCRMLT),IG(LCIZON),NMLTAR,NZONAR,
     &                        IEVTPF)
          IF(IUNIT(7).GT.0)
     &        CALL GWF1GHB6RP(RX(LCBNDS),NBOUND,MXBND,IUNIT(7),
     1                        IOUT,NGHBVL,IGHBAL,IFREFM,NCOL,NROW,NLAY,
     2                        NNPGHB,NPGHB,IGHBPB,NOPRGB)
          IF(IUNIT(8).GT.0)
     &        CALL GWF1RCH6RP(NRCHOP,IR(LCIRCH),RX(LCRECH),GX(LCDELR),
     1                        GX(LCDELC),NROW,NCOL,IUNIT(8),IOUT,IFREFM,
     2                        NPRCH,GX(LCRMLT),IG(LCIZON),NMLTAR,NZONAR,
     &                        IRCHPF)
          IF (IUNIT(17).GT.0)
     &        CALL RES1RP(IR(LCIRES),IR(LCIRSL),RX(LCBRES),
     &                    RX(LCCRES),RX(LCBBRE),RX(LCHRSE),IG(LCIBOU),
     &                    GX(LCDELR),GX(LCDELC),NRES,NRESOP,NPTS,NCOL,
     &                    NROW,NLAY,PERLEN(KKPER),DELT,NSTP(KKPER),
     &                    TSMULT(KKPER),IUNIT(17),IOUT)
          IF (IUNIT(18).GT.0)
     &        CALL GWF1STR6RP(RX(LCSTRM_),IR(ICSTRM_),NSTREM,MXSTRM,
     &                    IUNIT(18),IOUT,IR(LCTBAR),NDIV,NSSSTR6,NTRIB,
     &                    IR(LCIVAR_),ICALC,IPTFLG,NCOL,NROW,NLAY,
     &                    NPSTR,ISTRPB)
          IF(IUNIT(20).GT.0)
     &        CALL GWF1CHD6RP(RX(LCCHDS),NCHDS,MXCHD,IG(LCIBOU),NCOL,
     &                        NROW,NLAY,IUNIT(20),IOUT,NCHDVL,IFREFM,
     &                        NNPCHD,NPCHD,IPCBEG,NOPRCH)
CLAK
          IF(IUNIT(22).GT.0) THEN
            CALL LAK3RP(IR(ICLAKE),LKNODE,MXLKND,
     1        IUNIT(22),IOUT,NLAKES,RX(LCSTAG),RX(LCLKPR),RX(LCLKEV),
     2        RX(LCCOND),NTRB,NDV,IR(INTRB),IR(INDV),KKPER,
     3        GX(LCDELR),GX(LCDELC),
     4        NCOL,NROW,NLAY,IR(IICS),RX(LKACC7),GX(LCBOTM),NBOTM,
     5        IR(IISUB),RX(ISILL),ICMX,NCLS,RX(LCWTDR),LWRT,IFREFM,
     6        IR(IBNLK),RX(ILKBL),IR(IBNLK),RX(ILKBL),NODES,
     7        RX(IBTMS),RX(LCRNF),RX(IAREN),IUNIT(44),NSS,
     8        IUNIT(15),RX(LSLAKE),RX(LSAUG),RX(LSPPT),RX(LSRNF),
     9        NSOL,IOUTS,RX(LKSSMN),RX(LKSSMX),ISSFLG(KKPER),RX(LKVI),
     *        RX(LKCLKI),RX(LKCUM1),RX(LKCUM2),RX(LKCUM3),RX(LKCUM4),
     &        RX(LKCUM5),RX(LKCUM6),RX(LKCUM7),RX(LKCUM8),
     &        RX(LKCUM9))
            IF (IUNIT(1).GT.0) THEN
              CALL GWF1LAK3BCF6RP(IOUT,RX(LCCOND),IR(IBNLK),
     1             IR(ICLAKE),RX(LCCNDF),GX(LCDELR),GX(LCDELC),
     2             RX(LCHY),RX(LCTRPY),LAYHDT,MXLKND,NCOL,NROW,NLAY,
     3             LKNODE,IWDFLG,RX(LCCVWD))
            ELSE IF (IUNIT(23).GT.0) THEN
              CALL GWF1LAK3LPF1RP(IOUT,RX(LCCOND),IR(IBNLK),
     1             IR(ICLAKE),RX(LCCNDF),GX(LCDELR),GX(LCDELC),
     2             X(LCHK),X(LCHANI),LAYHDT,MXLKND,NCOL,NROW,NLAY,
     3             LKNODE,X(LCVKA),X(LCVKCB),GX(LCBOTM),NBOTM)
            ELSE IF(IUNIT(37).GT.0) THEN
              CALL GWF1LAK3HUF1RP(IOUT,RX(LCCOND),IR(IBNLK),
     1             IR(ICLAKE),RX(LCCNDF),GX(LCDELR),GX(LCDELC),
     2             X(LCHK),X(LCHKCC),LAYHDT,MXLKND,NCOL,NROW,NLAY,
     3             LKNODE,X(LCVKA),GX(LCBOTM),NBOTM)
            ELSE
              WRITE(IOUT,*) 'LAK Package requires BCF, LPF, or HUF'
              STOP
            END IF
cc  Uncomment following call when SFR is added -- ERB 7/9/01
cc            IF (IUNIT(44).GT.0)
cc     &          CALL LSN3RP(NTRB,NDV,NLAKES,IR(INTRB),IR(INDV),NSS,
cc     &                      IR(LCIVAR),IR(LCOTSG),IOUT,NODES,GX(LCBUFF))
          END IF
CLAK
          IF (IUNIT(46).GT.0.AND.
     &           (IUNIT(44).GT.0.OR.IUNIT(22).GT.0).AND.KKPER.EQ.1)
     &        CALL GAGE5I(IR(LSGAGE),NUMGAGE,IOUT,IUNIT(15),RX(LCSTAG),
     &          RX(LSLAKE),NLAKES,IR(ICSTRM),NSTRM,DUM,NSOL,RX(LKACC7))
          IF(IUNIT(39).GT.0)
     &        CALL GWF1ETS1RP(NETSOP,IR(LCIETS),RX(LCETSR),RX(LCETSX),
     &                        RX(LCETSS),GX(LCDELR),GX(LCDELC),NCOL,
     &                        NROW,IUNIT(39),IOUT,IFREFM,NPETS,
     &                        GX(LCRMLT),IG(LCIZON),NMLTAR,NZONAR,
     &                        IETSPF,NETSEG,RX(LCPXDP),RX(LCPETM),
     &                        NSEGAR)
          IF(IUNIT(40).GT.0)
     &        CALL GWF1DRT1RP(RX(LCDRTF),NDRTCL,MXDRT,IUNIT(40),
     &                        IOUT,NDRTVL,IDRTAL,IFREFM,NCOL,NROW,NLAY,
     &                        NDRTNP,NPDRT,IDRTPB,IDRTFL,NRFLOW,NOPRDT)
          IF(IUNIT(43).GT.0 .AND. IUNIT(18).GT.0 .AND. KPER.EQ.1)
     &        CALL HYD1STR6RP(IR(ICSTRM_),RX(LCHYDM),NHYDM,NUMH,
     &                        GX(LCDELR),GX(LCDELC),NCOL,NROW,NLAY,
     &                        LCIBOU,LCSTRM_,NSTREM,IUNIT(43),IOUT,
     &                        MXSTRM)
          IF(IUNIT(43).GT.0 .AND. KPER.EQ.1)
     &        CALL HYD1BAS6OT(GZ,LENGZ,RX,LENRX,IG,LENIG,RX(LCHYDM),
     &                        NUMH,IHYDMUN,0.0,HYDNOH,NROW,NCOL,
     &                        ITMUNI,IOUT)
C
C-----INITIALIZE SV ARRAY
          IF (IPAR.GT.-3 .AND. IUNIT(23).GT.0)
     &        CALL SEN1LPF1SV(IG(LCIZON),KKPER,NCOL,NLAY,NMLTAR,NPLIST,
     &                        NROW,NZONAR,GX(LCRMLT),X(LCSV))
C
C7C-----SIMULATE EACH TIME STEP.
          DO 90 KSTP = 1, NSTP(KKPER)
            KKSTP = KSTP
C
C7C1----CALCULATE TIME STEP LENGTH. SET HOLD=HNEW.
            CALL GWF1BAS6AD(DELT,TSMULT(KKPER),TOTIM,PERTIM,GZ(LCHNEW),
     1                      GX(LCHOLD),KKSTP,NCOL,NROW,NLAY,ITS)
            IF (IUNIT(20).GT.0)
     &          CALL GWF1CHD6AD(NCHDS,MXCHD,RX(LCCHDS),GZ(LCHNEW),
     &                          GX(LCHOLD),PERLEN(KKPER),PERTIM,NCOL,
     &                          NROW,NLAY,NCHDVL,IOUT)
            IF (IUNIT(1).GT.0)
     &          CALL GWF1BCF6AD(IG(LCIBOU),GX(LCHOLD),GX(LCBOTM),NBOTM,
     &                          RX(LCWETD),IWDFLG,ISSFLG(KKPER),NCOL,
     &                          NROW,NLAY)
            IF (IUNIT(23).GT.0)
     &          CALL GWF1LPF1AD(IG(LCIBOU),GX(LCHOLD),GX(LCBOTM),
     &                          X(LCWETD),ISSFLG(KKPER),NCOL,NROW,NLAY,
     &                          NBOTM)
            IF (IUNIT(37).GT.0)
     &          CALL GWF1HUF1AD(IG(LCIBOU),GX(LCHOLD),GX(LCBOTM),
     &                          X(LCWETD),ISSFLG(KKPER),NCOL,NROW,NLAY,
     &                          NBOTM)
            IF(IUNIT(16).GT.0)
     &          CALL FHB1AD(GZ(LCHNEW),GX(LCHOLD),NCOL,NROW,NLAY,ISS,
     &                      TOTIM,DELT,RX(LCBDTM),NBDTIM,RX(LCFLRT),
     &                      RX(LCBDFV),RX(LCBDHV),NFLW,RX(LCSBHD),
     &                      IR(LCHDLC),NHED,NFHBX1,NFHBX2,IFHBD3,IFHBD4,
     &                      IFHBD5,IFHBSS,NHEDDIM,NFLWDIM,NBDHVDIM)
            IF (IUNIT(17).GT.0)
     &          CALL RES1AD(RX(LCHRES),RX(LCHRSE),IR(LCIRES),RX(LCBRES),
     &                      GX(LCDELR),GX(LCDELC),NRES,IRESPT,NCOL,NROW,
     &                      PERLEN(KKPER),PERTIM,TOTIM,KKSTP,KKPER,IOUT)
CLAK
            IF (IUNIT(22).GT.0)
     1           CALL LAK3AD(KKPER,KKSTP,NLAKES,RX(ISTGLD),
     2                       RX(ISTGNW),RX(LCSTAG),NROW,NCOL,NLAY,
     3                       RX(LSFLOB),IUNIT(15),LKNODE,RX(ISTGLD2))
C
C---------INDICATE IN PRINTOUT THAT SOLUTION IS FOR HEADS
            CALL UMESPR('SOLVING FOR HEAD',' ',IOUT)
C
C7C2----ITERATIVELY FORMULATE AND SOLVE THE FLOW EQUATIONS.
C
            DO 30 KITER = 1, MXITER
              KKITER = KITER
C
C7C2A---FORMULATE THE FINITE DIFFERENCE EQUATIONS.
              CALL GWF1BAS6FM(GX(LCHCOF),GX(LCRHS),NODES)
              IF (IUNIT(1).GT.0)
     &            CALL GWF1BCF6FM(GX(LCHCOF),GX(LCRHS),GX(LCHOLD),
     &                            RX(LCSC1),GZ(LCHNEW),IG(LCIBOU),
     &                            GX(LCCR),GX(LCCC),GX(LCCV),RX(LCHY),
     &                            RX(LCTRPY),GX(LCBOTM),NBOTM,RX(LCSC2),
     &                            GX(LCDELR),GX(LCDELC),DELT,
     &                            ISSFLG(KKPER),KKITER,KKSTP,KKPER,NCOL,
     &                            NROW,NLAY,IOUT,RX(LCWETD),IWDFLG,
     &                            RX(LCCVWD),WETFCT,IWETIT,IHDWET,HDRY,
     &                            GX(LCBUFF))
              IF (IUNIT(23).GT.0)
     &            CALL GWF1LPF1FM(GX(LCHCOF),GX(LCRHS),GX(LCHOLD),
     &                            X(LCSC1),GZ(LCHNEW),IG(LCIBOU),
     &                            GX(LCCR),GX(LCCC),GX(LCCV),X(LCHK),
     &                            X(LCHANI),X(LCVKA),GX(LCBOTM),
     &                            X(LCSC2),GX(LCDELR),GX(LCDELC),DELT,
     &                            ISSFLG(KKPER),KKITER,KKSTP,KKPER,NCOL,
     &                            NROW,NLAY,IOUT,X(LCWETD),WETFCT,
     &                            IWETIT,IHDWET,HDRY,NBOTM,X(LCVKCB))
              IF (IUNIT(37).GT.0)
     &            CALL GWF1HUF1FM(GX(LCHCOF),GX(LCRHS),GX(LCHOLD),
     &                            X(LCSC1),GZ(LCHNEW),IG(LCIBOU),
     &                            GX(LCCR),GX(LCCC),GX(LCCV),X(LCHK),
     &                            X(LCVKA),GX(LCBOTM),GX(LCDELR),
     &                            GX(LCDELC),DELT,ITRSS,ISSFLG(KKPER),
     &                            NCOL,NROW,NLAY,IOUT,X(LCWETD),NBOTM,
     &                            NHUF,GX(LCRMLT),IG(LCIZON),NMLTAR,
     &                            NZONAR,X(LCHUFTHK),X(LCHKCC),HDRY,
     &                            KKITER,KSTP,KPER,X(LCHUFTMP),
     &                            IX(LCHGUF),IWETIT,IHDWET,WETFCT)
              IF (IUNIT(21).GT.0)
     &            CALL GWF1HFB6FM(GX(LCBOTM),GX(LCCC),GX(LCCR),
     &                            GX(LCDELC),GX(LCDELR),RX(LCHFB),
     &                            GZ(LCHNEW),MXACTFB,NBOTM,NCOL,NHFB,
     &                            NLAY,NROW,LAYHDT)
              IF (IUNIT(2).GT.0)
     &            CALL GWF1WEL6FM(NWELLS,MXWELL,GX(LCRHS),RX(LCWELL),
     &                            IG(LCIBOU),NCOL,NROW,NLAY,NWELVL)
              IF (IUNIT(3).GT.0)
     &            CALL GWF1DRN6FM(NDRAIN,MXDRN,RX(LCDRAI),GZ(LCHNEW),
     &                            GX(LCHCOF),GX(LCRHS),IG(LCIBOU),NCOL,
     &                            NROW,NLAY,NDRNVL)
              IF (IUNIT(4).GT.0)
     &            CALL GWF1RIV6FM(NRIVER,MXRIVR,RX(LCRIVR),GZ(LCHNEW),
     &                            GX(LCHCOF),GX(LCRHS),IG(LCIBOU),NCOL,
     &                            NROW,NLAY,NRIVVL)
CLAK
              IF (IUNIT(5).GT.0) THEN
                IF(IUNIT(22).GT.0.AND.NEVTOP.EQ.3)
     1                CALL LAK3ST(0,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
                CALL GWF1EVT6FM(NEVTOP,IR(LCIEVT),RX(LCEVTR),
     &                          RX(LCEXDP),RX(LCSURF),GX(LCRHS),
     &                          GX(LCHCOF),IG(LCIBOU),GZ(LCHNEW),NCOL,
     &                          NROW,NLAY)
                IF(IUNIT(22).GT.0.AND.NEVTOP.EQ.3)
     1                CALL LAK3ST(1,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
              END IF
              IF (IUNIT(7).GT.0)
     &            CALL GWF1GHB6FM(NBOUND,MXBND,RX(LCBNDS),GX(LCHCOF),
     &                            GX(LCRHS),IG(LCIBOU),NCOL,NROW,NLAY,
     &                            NGHBVL)
CLAK
              IF (IUNIT(8).GT.0) THEN
                IF(IUNIT(22).GT.0.AND.NRCHOP.EQ.3)
     1                CALL LAK3ST(0,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
                CALL GWF1RCH6FM(NRCHOP,IR(LCIRCH),RX(LCRECH),
     &                            GX(LCRHS),IG(LCIBOU),NCOL,NROW,NLAY)
                IF(IUNIT(22).GT.0.AND.NRCHOP.EQ.3)
     1                CALL LAK3ST(1,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
              END IF
              IF(IUNIT(16).GT.0)
     &            CALL FHB1FM(GX(LCRHS),IG(LCIBOU),IR(LCFLLC),
     &                        RX(LCBDFV),NFLW,NCOL,NROW,NLAY,IFHBD4,
     &                        NFLWDIM)
              IF (IUNIT(17).GT.0)
     &            CALL RES1FM(IR(LCIRES),IR(LCIRSL),RX(LCBRES),
     &                        RX(LCCRES),RX(LCBBRE),RX(LCHRES),
     &                        IG(LCIBOU),GZ(LCHNEW),GX(LCHCOF),
     &                        GX(LCRHS),NRES,NRESOP,NCOL,NROW,NLAY)
              IF(IUNIT(18).GT.0)
     &            CALL GWF1STR6FM(NSTREM,RX(LCSTRM_),IR(ICSTRM_),
     &                        GZ(LCHNEW),GX(LCHCOF),GX(LCRHS),
     &                        IG(LCIBOU),MXSTRM,NCOL,NROW,NLAY,
     &                        NSSSTR6,IR(LCTBAR),NTRIB,RX(LCTRIB),
     &                        IR(LCIVAR_),IR(LCFGAR),ICALC,
     &                        CONSTSTR6)
              IF (IUNIT(19).GT.0)
     1            CALL GWF1IBS6FM(GX(LCRHS),GX(LCHCOF),GZ(LCHNEW),
     2                            GX(LCHOLD),RX(LCHC),RX(LCSCE),
     3                            RX(LCSCV),IG(LCIBOU),NCOL,NROW,NLAY,
     4                            DELT,ISSFLG(KKPER),IBSDIM)
CLAK
              IF (IUNIT(22).GT.0)
     *               CALL LAK3FM(LKNODE,MXLKND,IR(ICLAKE),
     1                      GZ(LCHNEW),GX(LCHCOF),GX(LCRHS),
     2                      IG(LCIBOU),NCOL,NROW,NLAY,NLAKES,
     3                      RX(ISTGLD),RX(LCCNDF),GX(LCBOTM),NBOTM,
     4                      IOUT,DELT,NSS,NTRB,NDV,IR(INTRB),IR(INDV),
     5                      RX(ISTRIN),RX(ISTROT),RX(ISTGNW),
     6                      RX(LCWTDR),RX(LCLKPR),RX(LCLKEV),
     7                      GX(LCDELR),GX(LCDELC),RX(LKACC1),
     8                      RX(LKACC2),RX(LKACC3),RX(LKACC4),
     9                      RX(LKACC5),RX(LKACC6),THETA,RX(LCRNF),
     *                      KKSTP,KKITER,ISSFLG(KKPER),NSSITR,SSCNCR,
     *                      RX(LKSSMN),RX(LKSSMX),RX(IDSTRT),IR(LKNCN),
     *                      RX(LKDSR),RX(LKCNN),RX(LKCHN),RX(IAREN),
     *                      IR(LKLMRR))
              IF (IUNIT(39).GT.0)
     &            CALL GWF1ETS1FM(NETSOP,IR(LCIETS),RX(LCETSR),
     &                            RX(LCETSX),RX(LCETSS),GX(LCRHS),
     &                            GX(LCHCOF),IG(LCIBOU),GZ(LCHNEW),NCOL,
     &                            NROW,NLAY,NETSEG,RX(LCPXDP),
     &                            RX(LCPETM),NSEGAR)
              IF (IUNIT(40).GT.0)
     &            CALL GWF1DRT1FM(NDRTCL,MXDRT,RX(LCDRTF),GZ(LCHNEW),
     &                            GX(LCHCOF),GX(LCRHS),IG(LCIBOU),NCOL,
     &                            NROW,NLAY,NDRTVL,IDRTFL)
C
C-------IF HNEW=HOLD=0 AND RHS=0, NO NEED TO SOLVE.
              CALL UNOITER(GX(LCRHS),GZ(LCHNEW),NODES,ISA)
              IF (ISA.EQ.0) THEN
                ICNVG = 1
                GOTO 33
              ENDIF
C
C7C2B---MAKE ONE CUT AT AN APPROXIMATE SOLUTION.
              IF (IUNIT(9).GT.0)
     &            CALL SIP5AP(GZ(LCHNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                        GX(LCCV),GX(LCHCOF),GX(LCRHS),X(LCEL),
     &                        X(LCFL),X(LCGL),X(LCV),X(LCW),X(LCHDCG),
     &                        IX(LCLRCH),NPARM,KKITER,HCLOSE,ACCL,
     &                        ICNVG,KKSTP,KKPER,IPCALC,IPRSIP,MXITER,
     &                        NSTP(KKPER),NCOL,NROW,NLAY,NODES,IOUT,0,
     &                        IERR,IERRU)
              IF (IUNIT(10).GT.0)
     &            CALL DE45AP(GZ(LCHNEW),IG(LCIBOU),X(LCAU),X(LCAL),
     &                        IX(LCIUPP),IX(LCIEQP),X(LCD4B),MXUP,
     &                        MXLOW,MXEQ,MXBW,GX(LCCR),GX(LCCC),
     &                        GX(LCCV),GX(LCHCOF),GX(LCRHS),ACCL,
     &                        KKITER,ITMX,MXITER,NITER,HCLOSE,IPRD4,
     &                        ICNVG,NCOL,NROW,NLAY,IOUT,IX(LCLRCH),
     &                        X(LCHDCG),IFREQ,KKSTP,KKPER,DELT,
     &                        NSTP(KKPER),ID4DIR,ID4DIM,MUTD4,IERR,
     &                        IERRU)
              IF (IUNIT(11).GT.0)
     &            CALL SOR5AP(GZ(LCHNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                        GX(LCCV),GX(LCHCOF),GX(LCRHS),X(LCA),
     &                        X(LCRES),IX(LCIEQP),X(LCHDCG),IX(LCLRCH),
     &                        KKITER,HCLOSE,ACCL,ICNVG,KKSTP,KKPER,
     &                        IPRSOR,MXITER,NSTP(KKPER),NCOL,NROW,NLAY,
     &                        NSLICE,MBW,IOUT,0)
              IF (IUNIT(13).GT.0)
     &            CALL PCG2AP(GZ(LCHNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                        GX(LCCV),GX(LCHCOF),GX(LCRHS),Z(LCV),
     &                        Z(LCSS),X(LCP),X(LCCD),X(LCHCHG),
     &                        IX(LCLHCH),X(LCRCHG),IX(LCLRCH),KKITER,
     &                        NITER,HCLOSE,RCLOSE,ICNVG,KKSTP,KKPER,
     &                        IPRPCG,MXITER,ITER1,NPCOND,NBPOL,
     &                        NSTP(KKPER),NCOL,NROW,NLAY,NODES,RELAX,
     &                        IOUT,MUTPCG,IX(LCIT1),DAMP,GX(LCBUFF),
     &                        X(LCHCSV),IERR,IERRU)
              IF (IUNIT(14).GT.0)
     &            CALL LMG1AP(GZ(LCHNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                        GX(LCCV),GX(LCHCOF),GX(LCRHS),Z(LCA),
     &                        IX(LCIA),IX(LCJA),Z(LCU1),Z(LCFRHS),
     &                        IX(LCIG),ISIZ1,ISIZ2,ISIZ3,ISIZ4,KKITER,
     &                        BCLOSE,DAMP,ICNVG,KKSTP,KKPER,MXITER,
     &                        MXCYC,NCOL,NROW,NLAY,NODES,HNOFLO,IOUT,
     &                        IOUTAMG,ICG,IADAMP,DUP,DLOW)
              IF (IERR.GT.0) THEN
C               WRITE MESSAGE RELATED TO BEALE'S MEASURE, IF
C               APPROPRIATE, THEN STOP EXECUTION.
                IF (IBEFLG.EQ.2) CALL PES1BAS6ER(IOUT,ITERPK,NPLIST)
                CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
              ENDIF
C
C7C2C---IF CONVERGENCE CRITERION HAS BEEN MET STOP ITERATING.
              IF (ICNVG.EQ.1) GOTO 33
  30        CONTINUE
            KITER = MXITER
C
C7C2C-----IF CONVERGENCE CRITERION HAS NOT BEEN MET . . .
C---------IF ESTIMATING PARAMETERS OR CALCULATING BEALE'S MEASURE, USE
C         THE AVAILABLE VALUES AND KEEP GOING
            IF (IPES.GT.0 .OR. IBEFLG.EQ.2) THEN
              ICNVG = 1
              ICNVGP = 0
            ENDIF
C---------PRINT THE DATA TABLE AND WARNING MESSAGES AND STOP EXCEPT
C         AS NOTED ABOVE
            IF (IPAR.GT.-3) THEN
              CALL UNOCONV(X(LCBUF1),X(LCBUF1+IPRAR),OBSNAM,X(LCH),
     &                     X(LCHOBS),IOUT,0,IPAR,IPR,KKPER,KKSTP,
     &                     IX(LCLN),MPR,ND,NDMH,NH,IX(LCNIPR),X(LCPRM),
     &                     X(LCBUF1+IPRAR+ND+MPR+IPR),RSQ,RSQF,RSQH,
     &                     RSQP,X(LCWP),X(LCWTPS),X(LCWT),X(LCWTQ),
     &                     X(LCWTQS),NPLIST,MPRAR,IPRAR,OUTNAM,
     &                     IX(LCIPLO),EQNAM,NAMES,IX(LCIPLP),NDMHAR,
     &                     NQTDR,NQTRV,NQTGB,NQTST,NQTCH,IOWTQDR,
     &                     IOWTQRV,IOWTQGB,IOWTQST,LCOBBAS,LCOBDRN,
     &                     LCOBRIV,LCOBGHB,LCOBSTR,LCOBCHD,LCOBADV,
     &                     X(LCSSGF),X(LCSSDR),X(LCSSRV),X(LCSSGB),
     &                     X(LCSSST),X(LCSSAD),X(LCSSCH),X(LCSSPI),
     &                     X(LCSSTO),ITMXP,IPES,X(LCBPRI),ITERP,IERR,
     &                     IERRU,NTT2,LCOBDRT,X(LCSSDT),NQTDT,IOWTQDT,
     &                     NRES,NPOST,NNEGT,NRUNS,NQTSF,IOWTQSF,LCOBSFR,
     &                     X(LCSSSF),KTDIM,NHT)
              IF (IPAR.EQ.1 .OR. IBEFLG.EQ.2) THEN
C               CONTINUE EXECUTION, BUT WRITE MESSAGE(S) REGARDING
C               NONCONVERGENCE
                CALL PES1BAS6NC(GX(LCCC),GX(LCCR),GX(LCCV),GX(LCHCOF),
     &                          GZ(LCHNEW),IBEFLG,IG(LCIBOU),IOUTG,
     &                          ITERPK,KKPER,KKSTP,NCOL,NLAY,NROW,
     &                          GX(LCRHS))
              ELSE
C               STOP EXECUTION
                CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
              ENDIF
            ENDIF
C
   33       CONTINUE
C
C7C3----DETERMINE WHICH OUTPUT IS NEEDED.
            CALL GWF1BAS6OC(NSTP(KKPER),KKSTP,ICNVG,IR(LCIOFL),NLAY,
     1                      IBUDFL,ICBCFL,IHDDFL,IUNIT(12),IOUT,KKPER,
     2                      IPEROC,ITSOC,IBDOPT,IXSEC,IFREFM)
C
C7C4----CALCULATE BUDGET TERMS. SAVE CELL-BY-CELL FLOW TERMS.
            MSUM = 1
C7C4A---THE ORIGINAL BCF BUDGET MODULE HAS BEEN REPLACED BY THREE
C7C4A---SUBMODULES: SGWF1BCF6S, SGWF1BCF6F, AND SGWF1BCF6B .
            IF (IUNIT(1).GT.0) THEN
              CALL SGWF1BCF6S(VBNM,VBVL,MSUM,GZ(LCHNEW),IG(LCIBOU),
     &                        GX(LCHOLD),RX(LCSC1),GX(LCBOTM),NBOTM,
     &                        RX(LCSC2),DELT,ISSFLG(KKPER),NCOL,NROW,
     &                        NLAY,KKSTP,KKPER,IBCFCB,ICBCFL,GX(LCBUFF),
     &                        IOUT,PERTIM,TOTIM)
              CALL SGWF1BCF6F(VBNM,VBVL,MSUM,GZ(LCHNEW),IG(LCIBOU),
     &                        GX(LCCR),GX(LCCC),GX(LCCV),DELT,NCOL,NROW,
     &                        NLAY,KKSTP,KKPER,IBCFCB,GX(LCBUFF),IOUT,
     &                        ICBCFL,PERTIM,TOTIM,GX(LCBOTM),NBOTM,
     &                        ICHFLG)
              IBDRET=0
              IC1=1
              IC2=NCOL
              IR1=1
              IR2=NROW
              IL1=1
              IL2=NLAY
              DO 37 IDIR = 1, 3
                CALL SGWF1BCF6B(GZ(LCHNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                          GX(LCCV),NCOL,NROW,NLAY,KKSTP,KKPER,
     &                          IBCFCB,GX(LCBUFF),IOUT,ICBCFL,DELT,
     &                          PERTIM,TOTIM,IDIR,IBDRET,ICHFLG,IC1,IC2,
     &                          IR1,IR2,IL1,IL2,GX(LCBOTM),NBOTM)
   37         CONTINUE
            ENDIF
            IF(IUNIT(23).GT.0) THEN
              CALL SGWF1LPF1S(VBNM,VBVL,MSUM,GZ(LCHNEW),IG(LCIBOU),
     &                        GX(LCHOLD),X(LCSC1),GX(LCBOTM),X(LCSC2),
     &                        DELT,ISSFLG(KKPER),NCOL,NROW,NLAY,KKSTP,
     &                        KKPER,ILPFCB,ICBCFL,GX(LCBUFF),IOUT,
     &                        PERTIM,TOTIM,NBOTM)
              CALL SGWF1LPF1F(VBNM,VBVL,MSUM,GZ(LCHNEW),IG(LCIBOU),
     &                        GX(LCCR),GX(LCCC),GX(LCCV),GX(LCBOTM),
     &                        DELT,NCOL,NROW,NLAY,KKSTP,KKPER,ILPFCB,
     &                        GX(LCBUFF),IOUT,ICBCFL,PERTIM,TOTIM,
     &                        NBOTM,ICHFLG)
              IBDRET=0
              IC1=1
              IC2=NCOL
              IR1=1
              IR2=NROW
              IL1=1
              IL2=NLAY
              DO 157 IDIR=1,3
                CALL SGWF1LPF1B(GZ(LCHNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                          GX(LCCV),GX(LCBOTM),NCOL,NROW,NLAY,
     &                          KKSTP,KKPER,ILPFCB,GX(LCBUFF),IOUT,
     &                          ICBCFL,DELT,PERTIM,TOTIM,IDIR,IBDRET,
     &                          ICHFLG,IC1,IC2,IR1,IR2,IL1,IL2,NBOTM)
157           CONTINUE
            ENDIF
            IF(IUNIT(37).GT.0) THEN
              CALL SGWF1HUF1S(VBNM,VBVL,MSUM,GZ(LCHNEW),IG(LCIBOU),
     &                        GX(LCHOLD),X(LCSC1),GX(LCBOTM),DELT,
     &                        ISSFLG(KKPER),NCOL,NROW,NLAY,KKSTP,KKPER,
     &                        IHUFCB,ICBCFL,GX(LCBUFF),IOUT,PERTIM,
     &                        TOTIM,NBOTM,X(LCHUFTHK),NHUF,IG(LCIZON),
     &                        NZONAR,GX(LCRMLT),NMLTAR,GX(LCDELR),
     &                        GX(LCDELC))
              CALL SGWF1HUF1F(VBNM,VBVL,MSUM,GZ(LCHNEW),IG(LCIBOU),
     &                        GX(LCCR),GX(LCCC),GX(LCCV),GX(LCBOTM),
     &                        DELT,NCOL,NROW,NLAY,KKSTP,KKPER,IHUFCB,
     &                        GX(LCBUFF),IOUT,ICBCFL,PERTIM,TOTIM,NBOTM,
     &                        ICHFLG)
              IBDRET=0
              IC1=1
              IC2=NCOL
              IR1=1
              IR2=NROW
              IL1=1
              IL2=NLAY
              DO 158 IDIR=1,3
                CALL SGWF1HUF1B(GZ(LCHNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                          GX(LCCV),GX(LCBOTM),NCOL,NROW,NLAY,
     &                          KKSTP,KKPER,IHUFCB,GX(LCBUFF),IOUT,
     &                          ICBCFL,DELT,PERTIM,TOTIM,IDIR,IBDRET,
     &                          ICHFLG,IC1,IC2,IR1,IR2,IL1,IL2,NBOTM)
158           CONTINUE
            ENDIF
C--WELLS
            IF (IUNIT(2).GT.0)
     &          CALL GWF1WEL6BD(NWELLS,MXWELL,VBNM,VBVL,MSUM,RX(LCWELL),
     &                          IG(LCIBOU),DELT,NCOL,NROW,NLAY,KKSTP,
     &                          KKPER,IWELCB,ICBCFL,GX(LCBUFF),IOUT,
     &                          PERTIM,TOTIM,NWELVL,IWELAL,IAUXSV)
C--DRAINS
            IF (IUNIT(3).GT.0)
     &          CALL GWF1DRN6BD(NDRAIN,MXDRN,VBNM,VBVL,MSUM,RX(LCDRAI),
     &                          DELT,GZ(LCHNEW),NCOL,NROW,NLAY,
     &                          IG(LCIBOU),KKSTP,KKPER,IDRNCB,ICBCFL,
     &                          GX(LCBUFF),IOUT,PERTIM,TOTIM,NDRNVL,
     &                          IDRNAL,IAUXSV)
C--RIVERS
            IF (IUNIT(4).GT.0)
     &          CALL GWF1RIV6BD(NRIVER,MXRIVR,RX(LCRIVR),IG(LCIBOU),
     &                          GZ(LCHNEW),NCOL,NROW,NLAY,DELT,VBVL,
     &                          VBNM,MSUM,KKSTP,KKPER,IRIVCB,ICBCFL,
     &                          GX(LCBUFF),IOUT,PERTIM,TOTIM,NRIVVL,
     &                          IRIVAL,IAUXSV)
C--EVAPOTRANSPIRATION
CLAK
            IF (IUNIT(5).GT.0) THEN
              IF(IUNIT(22).GT.0.AND.NEVTOP.EQ.3)
     1                CALL LAK3ST(0,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
              CALL GWF1EVT6BD(NEVTOP,IR(LCIEVT),RX(LCEVTR),RX(LCEXDP),
     &                          RX(LCSURF),IG(LCIBOU),GZ(LCHNEW),NCOL,
     &                          NROW,NLAY,DELT,VBVL,VBNM,MSUM,KKSTP,
     &                          KKPER,IEVTCB,ICBCFL,GX(LCBUFF),IOUT,
     &                          PERTIM,TOTIM)
              IF(IUNIT(22).GT.0.AND.NEVTOP.EQ.3)
     1                CALL LAK3ST(1,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
            END IF
C--GENERAL-HEAD BOUNDARIES
            IF (IUNIT(7).GT.0)
     &          CALL GWF1GHB6BD(NBOUND,MXBND,VBNM,VBVL,MSUM,RX(LCBNDS),
     &                          DELT,GZ(LCHNEW),NCOL,NROW,NLAY,
     &                          IG(LCIBOU),KKSTP,KKPER,IGHBCB,ICBCFL,
     &                          GX(LCBUFF),IOUT,PERTIM,TOTIM,NGHBVL,
     &                          IGHBAL,IAUXSV)
C--RECHARGE
CLAK
            IF (IUNIT(8).GT.0) THEN
              IF(IUNIT(22).GT.0.AND.NRCHOP.EQ.3)
     1                CALL LAK3ST(0,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
              CALL GWF1RCH6BD(NRCHOP,IR(LCIRCH),RX(LCRECH),IG(LCIBOU),
     &                          NROW,NCOL,NLAY,DELT,VBVL,VBNM,MSUM,
     &                          KKSTP,KKPER,IRCHCB,ICBCFL,GX(LCBUFF),
     &                          IOUT,PERTIM,TOTIM)
              IF(IUNIT(22).GT.0.AND.NRCHOP.EQ.3)
     1                CALL LAK3ST(1,NCOL,NROW,NLAY,IG(LCIBOU),LKNODE,
     2                            IR(ICLAKE),MXLKND,NLAKES,RX(ISTGLD),
     3                            GX(LCBOTM),NBOTM)
            END IF
C--Specified-Flow and Specified-Head Boundary
            IF(IUNIT(16).GT.0)
     &          CALL FHB1BD(IR(LCFLLC),RX(LCBDFV),NFLW,VBNM,VBVL,MSUM,
     &                      IG(LCIBOU),DELT,NCOL,NROW,NLAY,KKSTP,KKPER,
     &                      IFHBCB,ICBCFL,GX(LCBUFF),IOUT,IFHBD4,
     &                      NFLWDIM)
C--RESERVOIRS
            IF (IUNIT(17).GT.0)
     &          CALL RES1BD(IR(LCIRES),IR(LCIRSL),RX(LCBRES),RX(LCCRES),
     &                      RX(LCBBRE),RX(LCHRES),IG(LCIBOU),GZ(LCHNEW),
     &                      GX(LCBUFF),VBVL,VBNM,MSUM,KKSTP,KKPER,NRES,
     &                      NRESOP,NCOL,NROW,NLAY,DELT,IRESCB,ICBCFL,
     &                      IOUT)
C--STREAM-AQUIFER RELATIONS (STR6 PACKAGE)
            IF(IUNIT(18).GT.0)
     &          CALL GWF1STR6BD(NSTREM,RX(LCSTRM_),IR(ICSTRM_),
     &                      IG(LCIBOU),MXSTRM,GZ(LCHNEW),NCOL,NROW,
     &                      NLAY,DELT,VBVL,VBNM,MSUM,KKSTP,KKPER,
     &                      ISTCB1STR6,ISTCB2STR6,ICBCFL,GX(LCBUFF),
     &                      IOUT,NTRIB,NSSSTR6,RX(LCTRIB),IR(LCTBAR),
     &                      IR(LCIVAR_),IR(LCFGAR),ICALC,CONSTSTR6,
     &                      IPTFLG)
C--INTERBED STORAGE
            IF (IUNIT(19).GT.0)
     1          CALL GWF1IBS6BD(IG(LCIBOU),GZ(LCHNEW),GX(LCHOLD),
     2                          RX(LCHC),RX(LCSCE),RX(LCSCV),RX(LCSUB),
     3                          GX(LCDELR),GX(LCDELC),NCOL,NROW,NLAY,
     4                          DELT,VBVL,VBNM,MSUM,KSTP,KPER,IIBSCB,
     5                          ICBCFL,GX(LCBUFF),IOUT,ISSFLG(KKPER),
     6                          IBSDIM)
C--LAKES
            IF (IUNIT(22).GT.0)
     &          CALL LAK3BD(LKNODE,MXLKND,NODES,IR(ICLAKE),GZ(LCHNEW),
     &                      IG(LCIBOU),NCOL,NROW,NLAY,NLAKES,DELT,NSS,
     &                      NTRB,NDV,IR(INTRB),IR(INDV),RX(ISTRIN),
     &                      RX(ISTROT),RX(ISTGLD),RX(ISTGNW),RX(LCCNDF),
     &                      RX(LCLKPR),RX(LCLKEV),GX(LCDELR),GX(LCDELC),
     &                      GX(LCBOTM),NBOTM,VBVL,VBNM,MSUM,KSTP,KPER,
     &                      ILKCB,ICBCFL,GX(LCBUFF),IOUT,RX(LCSTAG),
     &                      PERTIM,TOTIM,IR(IICS),IR(IISUB),RX(ISILL),
     &                      ICMX,NCLS,RX(LCWTDR),LWRT,RX(LKACC1),
     &                      RX(LKACC2),RX(LKACC3),RX(LKACC4),RX(LKACC5),
     &                      RX(LKACC6),RX(LKACC7),RX(LKACC8),RX(LKACC9),
     &                      RX(LKACC10),RX(LKACC11),IR(LKDRY),RX(IBTMS),
     &                      IR(LKNCNT),IR(LKKSUB),RX(LKSADJ),RX(LKFLXI),
     &                      IR(LKNCNS),RX(LKSVT),IR(LKJCLS),RX(LCRNF),
     &                      THETA,RX(LKCNN),RX(LKCHN),RX(IAREN),
     &                      IUNIT(15),KCNT,IR(IMSUB),IR(IMSUB1),
     &                      IUNIT(46),NUMGAGE,IR(LSGAGE),RX(LSOVOL),
     &                      RX(LSFLOB),ISSFLG(KPER),LAYHDT,
     &                      IAUXSV,RX(LKVI),RX(ISTGLD2),RX(LKCUM1),
     &                      RX(LKCUM2),RX(LKCUM3),
     &                      RX(LKCUM4),RX(LKCUM5),RX(LKCUM6),
     &                      RX(LKCUM7),RX(LKCUM8),RX(LKCUM9))
C--EVAPOTRANSPIRATION WITH SEGMENTED RATE FUNCTION
            IF (IUNIT(39).GT.0)
     &          CALL GWF1ETS1BD(NETSOP,IR(LCIETS),RX(LCETSR),RX(LCETSX),
     &                          RX(LCETSS),IG(LCIBOU),GZ(LCHNEW),NCOL,
     &                          NROW,NLAY,DELT,VBVL,VBNM,MSUM,KKSTP,
     &                          KKPER,IETSCB,ICBCFL,GX(LCBUFF),IOUT,
     &                          PERTIM,TOTIM,NETSEG,RX(LCPXDP),
     &                          RX(LCPETM),NSEGAR)
C--DRAINS WITH RETURN FLOW
            IF (IUNIT(40).GT.0)
     &          CALL GWF1DRT1BD(NDRTCL,MXDRT,VBNM,VBVL,MSUM,RX(LCDRTF),
     &                          DELT,GZ(LCHNEW),NCOL,NROW,NLAY,
     &                          IG(LCIBOU),KKSTP,KKPER,IDRTCB,ICBCFL,
     &                          GX(LCBUFF),IOUT,PERTIM,TOTIM,NDRTVL,
     &                          IDRTAL,IDRTFL,NRFLOW,IAUXSV)
            IF (IUNIT(43).GT.0)
     &          CALL HYD1BAS6OT(GZ,LENGZ,RX,LENRX,IG,LENIG,RX(LCHYDM),
     &                        NUMH,IHYDMUN,TOTIM,HYDNOH,NROW,NCOL,
     &                        ITMUNI,IOUT)
CLMT
CLMT----CALL LINK-MT3DMS SUBROUTINES TO SAVE FLOW-TRANSPORT LINK FILE
CLMT----FOR USE BY MT3DMS FOR TRANSPORT SIMULATION
CLMT
            INCLUDE 'lmt6.inc'
CLMT
C------SET FLAG WHICH INDICATES WHETHER THERE IS AN OBS. THIS TIME STEP
            IF (IPAR.EQ.0) THEN
              CALL OBS1BAS6FD(IFLD,IX(LCNDER),NH,X(LCTOFF),NQ,
     &                        IX(LCNQOB),IX(LCIQOB),NQAR,NQTAR,NHAR,
     &                        ND,ITS)
C          FD ROUTINES FOR OTHER OBSERVATION PACKAGES GO HERE (ADV, MNW)
            ENDIF
            IF (IPRINTS.EQ.1) IFLD = 1
C
C7C5---PRINT AND/OR SAVE HEAD AND DRAWDOWN MATRICES.
C------PRINT OVERALL WATER BUDGET.
            CALL GWF1BAS6OT(GZ(LCHNEW),GX(LCSTRT),ISTRT,GX(LCBUFF),
     &                      IR(LCIOFL),MSUM,IG(LCIBOU),VBNM,VBVL,KKSTP,
     &                      KKPER,DELT,PERTIM,TOTIM,ITMUNI,NCOL,NROW,
     &                      NLAY,ICNVG,IHDDFL,IBUDFL,IHEDFM,IHEDUN,
     &                      IDDNFM,IDDNUN,IOUT,CHEDFM,CDDNFM,IXSEC,
     &                      LBHDSV,LBDDSV,IBOUUN,LBBOSV,CBOUFM,ISA)
            IF (IUNIT(19).GT.0)
     1           CALL GWF1IBS6OT(NCOL,NROW,NLAY,PERTIM,TOTIM,KKSTP,
     2                           KKPER,NSTP(KKPER),GX(LCBUFF),RX(LCSUB),
     3                           RX(LCHC),IIBSOC,ISUBFM,ICOMFM,IHCFM,
     4                           ISUBUN,ICOMUN,IHCUN,IUNIT(19),IOUT,
     5                           ISSFLG(KKPER),IBSDIM)
C------PRINT AND/OR SAVE HEADS INTERPOLATED TO HYDROGEOLOGIC UNITS
            IF(IUNIT(37).GT.0.AND.IOHUF.NE.0)
     &          CALL GWF1HUF1OT(IOHUF,GZ(LCHNEW),IHEDFM,IG(LCIBOU),
     1                      NHUF,NCOL,NROW,NLAY,X(LCHUFTHK),GX(LCBOTM),
     2                      NBOTM,GX(LCCV),GX(LCDELR),GX(LCDELC),
     3                      GX(LCRMLT),NMLTAR,IG(LCIZON),NZONAR,KKSTP,
     4                      KKPER,ISA,ICNVG,IOUT,HNOFLO,CHEDFM,LBHDSV,
     5                      PERTIM,TOTIM,X(LCHUFTMP))
C
C-------OBSERVATION CALCULATIONS
            IF (IPAR.NE.-3 .AND. ND.GT.0) THEN
C
C7C6----IF ITERATION FAILED TO CONVERGE THEN STOP.
              IF (ICNVG.EQ.0) CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
C
C-------WRITE INITIAL PARAMETER VALUES ON FILE IOUB
              IF (IPES.GT.0)
     &          CALL PES1BAS6WB(X(LCBL),X(LCBU),IX(LCISEN),IOUB,ITERP,
     &                          ITS,IX(LCLN),NPLIST,X(LCBSCA),IOSTAR,
     &                          NPE,X(LCPARE),ITMXP,ITERPF,ITERPK)
C
C-------INTERPOLATE, SAVE AND PRINT DATA FOR OBSERVATIONS.
              IF (IUNIT(28).NE.0 .AND. NH.GT.0)
     &            CALL OBS1BAS6HFM(NH,IX(LCNDER),IX(LCIOFF),IX(LCJOFF),
     &                             IX(LCMLAY),IG(LCIBOU),X(LCRINT),
     &                             OBSNAM,X(LCCOFF),X(LCROFF),
     &                             GX(LCDELR),GX(LCDELC),NCOL,NROW,NLAY,
     &                             X(LCPR),X(LCH),X(LCWT),GZ(LCHNEW),
     &                             IDRY,NPE,X(LCTOFF),MAXM,JDRY,
     &                             IPAR,IOUT,ITS,NHAR,MOBSAR,ND,IPES,
     &                             IYCFLG,GX(LCSTRT))
              IF (NQ.GT.0) THEN
                IF (IUNIT(3).NE.0)
     &              CALL OBS1DRN6FM(NQ,IX(LCNQOB),IX(LCNQCL),
     &                              IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                              GZ(LCHNEW),NCOL,NROW,NLAY,IOUT,
     &                              IG(LCIBOU),NHT,OBSNAM,X(LCH),
     &                              X(LCTOFF),MXDRN,NDRAIN,RX(LCDRAI),
     &                              X(LCWTQ),NDMH,ITS,NQAR,NQCAR,NQTAR,
     &                              NDRNVL,ND)
                IF (IUNIT(4).NE.0)
     &              CALL OBS1RIV6FM(NQ,IX(LCNQOB),IX(LCNQCL),
     &                              IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                              MXRIVR,NRIVER,RX(LCRIVR),GZ(LCHNEW),
     &                              NCOL,NROW,NLAY,IOUT,IG(LCIBOU),NH,
     &                              OBSNAM,X(LCH),X(LCTOFF),X(LCWTQ),
     &                              NDMH,ITS,NQAR,NQCAR,NQTAR,NRIVVL,ND)
                IF (IUNIT(7).NE.0)
     &              CALL OBS1GHB6FM(NQ,IX(LCNQOB),IX(LCNQCL),
     &                              IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                              MXBND,NBOUND,RX(LCBNDS),GZ(LCHNEW),
     &                              NCOL,NROW,NLAY,IOUT,IG(LCIBOU),NHT,
     &                              OBSNAM,X(LCH),X(LCTOFF),ITS,NQAR,
     &                              NQCAR,NQTAR,NGHBVL,ND,X(LCWTQ),NDMH)
                IF (IUNIT(18).NE.0)
     &              CALL OBS1STR6FM(NQ,IX(LCNQOB),IX(LCNQCL),
     &                              IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                              GZ(LCHNEW),NCOL,NROW,NLAY,IOUT,
     &                              IG(LCIBOU),NHT,OBSNAM,X(LCH),
     &                              X(LCTOFF),MXSTRM,NSTREM,RX(LCSTRM_),
     &                              IR(ICSTRM_),X(LCWTQ),NDMH,ITS,NQAR,
     &                              NQCAR,NQTAR,ND)
                IF (IUNIT(38).NE.0)
     &              CALL OBS1BAS6FFM(NQ,IX(LCNQOB),IX(LCNQCL),
     &                               IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                               GZ(LCHNEW),NCOL,NROW,NLAY,
     &                               IG(LCIBOU),NHT,X(LCH),
     &                               X(LCTOFF),ITS,NQAR,NQCAR,NQTAR,
     &                               ICHFLG,GX(LCCR),GX(LCCC),GX(LCCV),
     &                               GX(LCBOTM),NBOTM,LAYHDT,ND,IOUT,
     &                               KKPER)
                IF (IUNIT(40).NE.0)
     &              CALL OBS1DRT1FM(NQ,IX(LCNQOB),IX(LCNQCL),
     &                              IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                              GZ(LCHNEW),NCOL,NROW,NLAY,IOUT,
     &                              IG(LCIBOU),NHT,OBSNAM,X(LCH),
     &                              X(LCTOFF),MXDRT,NDRTCL,RX(LCDRTF),
     &                              X(LCWTQ),NDMH,ITS,NQAR,NQCAR,NQTAR,
     &                              NDRTVL,ND)
              ENDIF
              IF (IUNIT(29).NE.0 .AND. ISSFLG(KKPER).EQ.1)
     &            CALL OBS1ADV2P(NROW,NCOL,NLAY,GX(LCDELC),GX(LCDELR),
     &                           IOUT,GX(LCCR),GX(LCCC),GX(LCCV),
     &                           GZ(LCHNEW),IG(LCIBOU),OBSNAM,X(LCPOFF),
     &                           NHT,NQT,NTT2,NPTH,IX(LCNPNT),KTDIM,
     &                           KTFLG,KTREV,ADVSTP,
     &                           IX(LCICLS),X(LCPRST),0,GX(LCRMLT),
     &                           X(LCHK),IG(LCIZON),X(LCH),
     &                           X(LCX),NPE,ND,X(LCTT2),IPRINT,ITERP,
     &                           IOUTT2,MXBND,NBOUND,RX(LCBNDS),NRCHOP,
     &                           IR(LCIRCH),RX(LCRECH),MXSTRM,NSTREM,
     &                           IR(ICSTRM_),RX(LCSTRM_),MXRIVR,NRIVER,
     &                           RX(LCRIVR),MXDRN,NDRAIN,RX(LCDRAI),
     &                           X(LCSV),NMLTAR,NZONAR,GX(LCBOTM),NBOTM,
     &                           RX(LCWELL),NWELVL,MXWELL,NWELLS,
     &                           Z(LCSNEW),X(LCVKA),
     &                           IUNIT(21),RX(LCHFB),MXACTFB,NHFB,
     &                           X(LCHANI),NGHBVL,NRIVVL,NDRNVL,LAYHDT,
     &                           IX(LCLN),NPLIST,ISCALS,FSNK,X(LCWTQ),
     &                           NDMH,X(LCBSCA),X(LCHKCC),X(LCHUFTHK),
     &                           NHUF,IUNIT(23),IUNIT(37))
              CALL OBS1BAS6SS(IOUT,NPE,NH,OBSNAM,KKPER,KKSTP,X(LCBUF1),
     &                        X(LCX),X(LCH),X(LCWT),X(LCHOBS),IPRINT,
     &                        IFO,ITERP,IPAR,NPER,IX(LCLN),LASTX,ISCALS,
     &                        X(LCWP),MPR,X(LCPRM),RSQ,
     &                        RSQP,IPR,IX(LCNIPR),X(LCWTPS),ND,RSQF,
     &                        X(LCWTQ),X(LCWTQS),IOWTQ,NDMH,NTT2,KTDIM,
     &                        IOSTAR,NPLIST,NSTP,MPRAR,IPRAR,OUTNAM,
     &                        IX(LCIPLO),EQNAM,NAMES,IX(LCIPLP),NDMHAR,
     &                        NQTDR,NQTRV,NQTGB,NQTST,NQTCH,IOWTQDR,
     &                        IOWTQRV,IOWTQGB,IOWTQST,LCOBBAS,LCOBDRN,
     &                        LCOBRIV,LCOBGHB,LCOBSTR,LCOBCHD,LCOBADV,
     &                        X(LCSSGF),X(LCSSDR),X(LCSSRV),X(LCSSGB),
     &                        X(LCSSST),X(LCSSAD),X(LCSSCH),X(LCSSPI),
     &                        X(LCSSTO),ITMXP,IOUTG,X(LCBUF2),IPES,
     &                        X(LCBPRI),X(LCBSCA),X(LCRSQA),X(LCRSPA),
     &                        LCOBDRT,X(LCSSDT),NQTDT,IOWTQDT,NRES,
     &                        NPOST,NNEGT,NRUNS,NQTSF,IOWTQSF,LCOBSFR,
     &                        X(LCSSSF),NHT)
            ENDIF
C-----------SKIP OVER SENSITIVITY LOOP?
            IF (IPAR.NE.-3) THEN
              IF (IPAR.EQ.-1) GOTO 90
              IF (IFO.EQ.1 .AND. LASTX.EQ.0) GOTO 90
            ELSE
C7C6------IF ITERATION FAILED TO CONVERGE THEN STOP.
              IF (ICNVG.EQ.0) CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
              GOTO 90
            ENDIF
C
            CALL PLL1AS(NPE)
C
C-----------LOOP THROUGH THE PARAMETERS THAT ARE TO BE ESTIMATED TO
C           CALCULATE SENSITIVITIES
C
            DO 80 KKIP = 1,NPE
              IP = KKIP
C           TO SUBROUTINE?
C             DO THOSE IP ITEMS ASSIGNED TO THIS PROCESSOR
              IF (IPDO(IP).EQ.MYID) THEN
              ELSE
                GOTO 80
              ENDIF
C-----------ASSIGN PARAMETER-APPROPRIATE CONVERGENCE CRITERIA AND OTHER
C           PARAMETER-SPECIFIC SETTINGS
              CALL SEN1BAS6CL(X(LCHCLO),X(LCRCLO),FAC,HCLOSES,IP,NPLIST,
     &                        RCLOSES,IIPP,PIDTMP,NCOL,NROW,NLAY,IUHEAD,
     &                        Z(LCSNEW),X(LCSOLD),XHS,LENXHS)
C-----------PRINT PARAMETER NAME
              CALL UMESPR('SOLVING PARAMETER SENSITIVITY FOR ',
     &                    PARNAM(IIPP),IOUT)
C
C7C2----ITERATIVELY FORMULATE AND SOLVE THE SENSITIVITY EQUATIONS.
C
              DO 60 KITER = 1, MXITER
                KKITER = KITER
C       PREPARE TO CALCULATE SENSITIVITY-EQUATION RHS FOR ONE PARAMETER
                CALL SEN1BAS6FM(NCOL,NLAY,NROW,GX(LCRHS))
C-------------CALCULATE MATRIX AND VECTOR DERIVATIVES, MULTIPLY BY
C-------------HEADS, AND ADD COMPONENTS TO RHS
                IF (PIDTMP.EQ.'GHB ')
     &              CALL SEN1GHB6FM(MXBND,RX(LCBNDS),GZ(LCHNEW),NCOL,
     &                              NROW,NLAY,IG(LCIBOU),GX(LCRHS),
     &                              IIPP,NGHBVL)
                IF (PIDTMP.EQ.'DRN ')
     &              CALL SEN1DRN6FM(MXDRN,RX(LCDRAI),GZ(LCHNEW),NCOL,
     &                              NROW,NLAY,IG(LCIBOU),GX(LCRHS),
     &                              IIPP,NDRNVL)
                IF (PIDTMP.EQ.'RIV ')
     &              CALL SEN1RIV6FM(MXRIVR,RX(LCRIVR),GZ(LCHNEW),NCOL,
     &                              NROW,NLAY,IG(LCIBOU),GX(LCRHS),
     &                              IIPP,NRIVVL)
                IF (PIDTMP.EQ.'STR ')
     &              CALL SEN1STR6FM(NSTREM,MXSTRM,RX(LCSTRM_),
     &                              GZ(LCHNEW),NCOL,NROW,NLAY,
     &                              IG(LCIBOU),GX(LCRHS),IR(ICSTRM_),
     &                              IIPP)
                IF (PIDTMP.EQ.'Q   ')
     &              CALL SEN1WEL6FM(NWELLS,MXWELL,RX(LCWELL),NCOL,NROW,
     &                              NLAY,IG(LCIBOU),GX(LCRHS),IIPP,
     &                              NWELVL)
                IF (PIDTMP.EQ.'HK  ' .OR. PIDTMP.EQ.'VK  ' .OR.
     &              PIDTMP.EQ.'VANI' .OR. PIDTMP.EQ.'SS  ' .OR.
     &              PIDTMP.EQ.'SY  ' .OR. PIDTMP.EQ.'VKCB' .OR.
     &              PIDTMP.EQ.'HANI') THEN
                  IF (IUNIT(23).NE.0)
     &                CALL SEN1LPF1FM(GX(LCRMLT),GZ(LCHNEW),NCOL,NROW,
     &                                NLAY,ISSFLG(KKPER),PIDTMP,X(LCHK),
     &                                GX(LCDELR),GX(LCDELC),IG(LCIBOU),
     &                                DELT,GX(LCRHS),GX(LCHOLD),
     &                                IG(LCIZON),GX(LCCV),X(LCSV),
     &                                NMLTAR,NZONAR,IIPP,GX(LCBOTM),
     &                                NBOTM,X(LCVKA),IUNIT(21),
     &                                RX(LCHFB),MXACTFB,NHFB,X(LCHANI))
                  IF (IUNIT(37).NE.0)
     &                CALL SEN1HUF1FM(GZ(LCHNEW),NCOL,NROW,NLAY,PIDTMP,
     &                                X(LCHK),X(LCHKCC),GX(LCDELR),
     &                                GX(LCDELC),IG(LCIBOU),GX(LCRHS),
     &                                GX(LCCV),GX(LCBOTM),NBOTM,
     &                                X(LCHUFTHK),NHUF,IIPP,IG(LCIZON),
     &                                NZONAR,GX(LCRMLT),NMLTAR,
     &                                IUNIT(21),RX(LCHFB),MXACTFB,NHFB,
     &                                GX(LCHOLD),DELT,ISSFLG(KKPER),
     &                                IOUT)
                ENDIF
                IF (IUNIT(23).NE.0)
     &              CALL SEN1LPF1UN(ISSFLG(KKPER),DELT,NCOL,NROW,NLAY,
     &                              X(LCSOLD),GZ(LCHNEW),Z(LCSNEW),
     &                              GX(LCDELR),GX(LCDELC),IG(LCIBOU),
     &                              GX(LCRHS),X(LCSC1),GX(LCCR),
     &                              GX(LCCC),KKITER,X(LCSC2),X(LCHK),
     &                              GX(LCBOTM),NBOTM,GX(LCHOLD),
     &                              GX(LCCV),X(LCHANI),X(LCVKA))
                IF (IUNIT(37).NE.0)
     &              CALL SEN1HUF1UN(ISSFLG(KKPER),DELT,NCOL,NROW,NLAY,
     &                              X(LCSOLD),GZ(LCHNEW),Z(LCSNEW),
     &                              GX(LCDELR),GX(LCDELC),IG(LCIBOU),
     &                              GX(LCRHS),X(LCSC1),GX(LCCR),
     &                              GX(LCCC),KKITER,X(LCHK),X(LCHKCC),
     &                              GX(LCBOTM),NBOTM,GX(LCHOLD),
     &                              GX(LCCV),X(LCHUFTHK),NHUF,
     &                              IG(LCIZON),NZONAR,GX(LCRMLT),
     &                              NMLTAR)
                IF (PIDTMP.EQ.'HFB ')
     &              CALL SEN1HFB6FM(GX(LCBOTM),GX(LCDELC),GX(LCDELR),
     &                              GZ(LCHNEW),RX(LCHFB),IIPP,MXACTFB,
     &                              MXHFB,NBOTM,NCOL,NLAY,NROW,
     &                              GX(LCRHS),LAYHDT,NHFBNP)
                IF (PIDTMP.EQ.'RCH ')
     &              CALL SEN1RCH6FM(NCOL,NROW,NLAY,GX(LCDELR),
     &                              GX(LCDELC),GX(LCRMLT),NRCHOP,
     &                              IR(LCIRCH),IG(LCIBOU),GX(LCRHS),
     &                              IG(LCIZON),NMLTAR,NZONAR,IIPP)
                IF (PIDTMP.EQ.'EVT ')
     &              CALL SEN1EVT6FM(NCOL,NROW,NLAY,GX(LCDELR),
     &                              GX(LCDELC),GX(LCRMLT),NEVTOP,
     &                              IR(LCIEVT),IG(LCIBOU),GX(LCRHS),
     &                              RX(LCSURF),RX(LCEXDP),GZ(LCHNEW),
     &                              IG(LCIZON),NMLTAR,NZONAR,IIPP)
                IF (PIDTMP.EQ.'CHD ')
     &              CALL SEN1CHD6FM(MXCHD,RX(LCCHDS),Z(LCSNEW),
     &                              PERLEN(KKPER),PERTIM,NCOL,NROW,NLAY,
     &                              NCHDVL,IOUT,IIPP,IERR,IERRU)
                IF (PIDTMP.EQ.'ETS ')
     &              CALL SEN1ETS1FM(NCOL,NROW,NLAY,GX(LCDELR),
     &                              GX(LCDELC),GX(LCRMLT),NETSOP,
     &                              IR(LCIETS),IG(LCIBOU),GX(LCRHS),
     &                              RX(LCETSS),RX(LCETSX),GZ(LCHNEW),
     &                              IG(LCIZON),NMLTAR,NZONAR,IIPP,
     &                              NETSEG,RX(LCPXDP),RX(LCPETM),NSEGAR)
                IF (PIDTMP.EQ.'DRT ')
     &              CALL SEN1DRT1FM(MXDRT,RX(LCDRTF),GZ(LCHNEW),NCOL,
     &                              NROW,NLAY,IG(LCIBOU),GX(LCRHS),
     &                              IIPP,NDRTVL,IDRTFL)
                IF (IERR.GT.0) GOTO 85
C
C-------IF SNEW=SOLD=0 AND RHS=0, NO NEED TO SOLVE.
                CALL UNOITER(GX(LCRHS),Z(LCSNEW),NODES,ISA)
                IF (ISA.EQ.0) THEN
                  ICNVG = 1
                  GOTO 70
                ENDIF
C
C7C2B---MAKE ONE CUT AT AN APPROXIMATE SOLUTION.
                IF (IUNIT(9).GT.0)
     &              CALL SIP5AP(Z(LCSNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                          GX(LCCV),GX(LCHCOF),GX(LCRHS),X(LCEL),
     &                          X(LCFL),X(LCGL),X(LCV),X(LCW),X(LCHDCG),
     &                          IX(LCLRCH),NPARM,KKITER,HCLOSES,ACCL,
     &                          ICNVG,KKSTP,KKPER,IPCALC,IPRSIP,MXITER,
     &                          NSTP(KKPER),NCOL,NROW,NLAY,NODES,IOUT,3,
     &                          IERR,IERRU)
                IF (IUNIT(10).GT.0)
     &              CALL DE45AP(Z(LCSNEW),IG(LCIBOU),X(LCAU),X(LCAL),
     &                          IX(LCIUPP),IX(LCIEQP),X(LCD4B),MXUP,
     &                          MXLOW,MXEQ,MXBW,GX(LCCR),GX(LCCC),
     &                          GX(LCCV),GX(LCHCOF),GX(LCRHS),ACCL,
     &                          KKITER,ITMX,MXITER,NITER,HCLOSES,IPRD4,
     &                          ICNVG,NCOL,NROW,NLAY,IOUT,IX(LCLRCH),
     &                          X(LCHDCG),0,KKSTP,KKPER,DELT,
     &                          NSTP(KKPER),ID4DIR,ID4DIM,3,IERR,IERRU)
                IF (IUNIT(11).GT.0)
     &              CALL SOR5AP(Z(LCSNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                          GX(LCCV),GX(LCHCOF),GX(LCRHS),X(LCA),
     &                          X(LCRES),IX(LCIEQP),X(LCHDCG),
     &                          IX(LCLRCH),KKITER,HCLOSES,ACCL,ICNVG,
     &                          KKSTP,KKPER,IPRSOR,MXITER,NSTP(KKPER),
     &                          NCOL,NROW,NLAY,NSLICE,MBW,IOUT,3)
                IF (IUNIT(13).GT.0)
     &              CALL PCG2AP(Z(LCSNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                          GX(LCCV),GX(LCHCOF),GX(LCRHS),Z(LCV),
     &                          Z(LCSS),X(LCP),X(LCCD),X(LCHCHG),
     &                          IX(LCLHCH),X(LCRCHG),IX(LCLRCH),KKITER,
     &                          NITER,HCLOSES,RCLOSES,ICNVG,KKSTP,KKPER,
     &                          IPRPCG,MXITER,ITER1,NPCOND,NBPOL,
     &                          NSTP(KKPER),NCOL,NROW,NLAY,NODES,RELAX,
     &                          IOUT,3,IX(LCIT1),DAMP,GX(LCBUFF),
     &                          X(LCHCSV),IERR,IERRU)
           IF (IUNIT(14).GT.0)
     &            CALL LMG1AP(Z(LCSNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                        GX(LCCV),GX(LCHCOF),GX(LCRHS),Z(LCA),
     &                        IX(LCIA),IX(LCJA),Z(LCU1),Z(LCFRHS),
     &                        IX(LCIG),ISIZ1,ISIZ2,ISIZ3,ISIZ4,KKITER,
     &                        BCLOSE,DAMP,ICNVG,KKSTP,KKPER,MXITER,
     &                        MXCYC,NCOL,NROW,NLAY,NODES,HNOFLO,IOUT,
     &                        10,ICG,IADAMP,DUP,DLOW)
                IF (IERR.GT.0) GOTO 85
C
C7C2C---IF CONVERGENCE CRITERION HAS BEEN MET STOP ITERATING.
                IF (ICNVG.EQ.1) GOTO 70
   60         CONTINUE
              KITER = MXITER
C
C7C2C-----IF CONVERGENCE CRITERION HAS NOT BEEN MET . . .
C---------IF ESTIMATING PARAMETERS OR CALCULATING BEALE'S MEASURE, USE
C         THE AVAILABLE VALUES AND KEEP GOING
              IF (IPES.GT.0 .OR. IBEFLG.EQ.2) THEN
                ICNVG = 1
                ICNVGP = 0
              ENDIF
C---------PRINT THE DATA TABLE AND WARNING MESSAGES AND STOP EXCEPT
C         AS NOTED ABOVE
              CALL UNOCONV(X(LCBUF1),X(LCBUF1+IPRAR),OBSNAM,X(LCH),
     &                     X(LCHOBS),IOUTG,IP,IPAR,IPR,KKPER,KKSTP,
     &                     IX(LCLN),MPR,ND,NDMH,NH,IX(LCNIPR),X(LCPRM),
     &                     X(LCBUF1+IPRAR+ND+MPR+IPR),RSQ,RSQF,RSQH,
     &                     RSQP,X(LCWP),X(LCWTPS),X(LCWT),X(LCWTQ),
     &                     X(LCWTQS),NPLIST,MPRAR,IPRAR,OUTNAM,
     &                     IX(LCIPLO),EQNAM,NAMES,IX(LCIPLP),NDMHAR,
     &                     NQTDR,NQTRV,NQTGB,NQTST,NQTCH,IOWTQDR,
     &                     IOWTQRV,IOWTQGB,IOWTQST,LCOBBAS,LCOBDRN,
     &                     LCOBRIV,LCOBGHB,LCOBSTR,LCOBCHD,LCOBADV,
     &                     X(LCSSGF),X(LCSSDR),X(LCSSRV),X(LCSSGB),
     &                     X(LCSSST),X(LCSSAD),X(LCSSCH),X(LCSSPI),
     &                     X(LCSSTO),ITMXP,IPES,X(LCBPRI),ITERP,IERR,
     &                     IERRU,NTT2,LCOBDRT,X(LCSSDT),NQTDT,IOWTQDT,
     &                     NRES,NPOST,NNEGT,NRUNS,NQTSF,IOWTQSF,LCOBSFR,
     &                     X(LCSSSF),KTDIM,NHT)
              IF (IPAR.NE.1 .AND. IBEFLG.NE.2) THEN
                IERR = 1
                GOTO 85
              ENDIF
C
   70         CONTINUE
C-------------CHECK ACCURACY OF SENSITIVITY CALCULATIONS
              CALL SEN1BAS6CK(Z(LCSNEW),IG(LCIBOU),GX(LCCR),GX(LCCC),
     &                        GX(LCCV),GX(LCHCOF),GX(LCRHS),NCOL,NROW,
     &                        NLAY,IOUT,X(LCSEND),NPE,NTIMES,IP,ITS)
C
C7C5---PRINT AND/OR SAVE SENSITIVITY MATRICES.
              IF ((IPAR.EQ.0 .AND. IFLD.EQ.1) .OR. IPAR.EQ.-2) THEN
                CALL SEN1BAS6OT(IHDDFL,IOUT,ISA,KKSTP,BB,IIPP,PIDTMP,
     &                          Z(LCSNEW),GX(LCBUFF),IR(LCIOFL),
     &                          IG(LCIBOU),KKPER,DELT,PERTIM,TOTIM,
     &                          ITMUNI,NCOL,NROW,NLAY,ICNVG,ISENFM,
     &                          ISENPU,ISENSU,CHEDFM,IXSEC,LBHDSV,
     &                          HNOFLO,IP,NPE,IPRINTS,IERR,X(LCBSCA),
     &                          NPLIST,IX(LCLN))
              ENDIF
C-------OBSERVATION CALCULATIONS
              IF (ND.GT.0) THEN
C
C7C6----IF ITERATION FAILED TO CONVERGE THEN STOP.
                IF (ICNVG.EQ.0) THEN
                  IERR = 1
                  GOTO 85
                ENDIF
C-------INTERPOLATE, SAVE AND PRINT SENSITIVITIES FOR OBSERVATIONS.
                IF (IUNIT(28).NE.0 .AND. NH.GT.0)
     &              CALL OBS1BAS6HDR(NH,IX(LCNDER),IX(LCIOFF),
     &                               IX(LCJOFF),IX(LCMLAY),X(LCRINT),
     &                               NCOL,NROW,NLAY,X(LCPR),X(LCWT),
     &                               Z(LCSNEW),X(LCX),IP,NPE,IX(LCLN),
     &                               X(LCTOFF),MAXM,IPAR,NPLIST,ITS,
     &                               NHAR,MOBSAR,ND)
                IF (NQ.GT.0) THEN
                  CALL OBS1BAS6IQ(X(LCQCLS),NQCAR)
                  IF (IUNIT(3).NE.0)
     &                CALL OBS1DRN6DR(NQ,IX(LCNQOB),IX(LCNQCL),
     &                                IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                                GZ(LCHNEW),IP,Z(LCSNEW),NCOL,NROW,
     &                                NLAY,IOUTG,IG(LCIBOU),NHT,X(LCX),
     &                                OBSNAM,NPE,IX(LCLN),X(LCTOFF),
     &                                MXDRN,NDRAIN,RX(LCDRAI),NPLIST,
     &                                ITS,NQAR,NQCAR,NQTAR,NDRNVL,IERR,
     &                                IERRU,ND)
                  IF (IUNIT(4).NE.0)
     &                CALL OBS1RIV6DR(NQ,IX(LCNQOB),IX(LCNQCL),
     &                                IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                                MXRIVR,NRIVER,RX(LCRIVR),
     &                                GZ(LCHNEW),IP,Z(LCSNEW),NCOL,NROW,
     &                                NLAY,IOUTG,IG(LCIBOU),NH,X(LCX),
     &                                OBSNAM,NPE,IX(LCLN),X(LCTOFF),
     &                                NPLIST,ITS,NQAR,NQCAR,NQTAR,
     &                                NRIVVL,IERR,IERRU,ND)
                  IF (IUNIT(7).NE.0)
     &                CALL OBS1GHB6DR(NQ,IX(LCNQOB),IX(LCNQCL),
     &                                IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                                MXBND,NBOUND,RX(LCBNDS),
     &                                GZ(LCHNEW),IP,Z(LCSNEW),NCOL,NROW,
     &                                NLAY,IOUTG,IG(LCIBOU),NHT,X(LCX),
     &                                OBSNAM,NPE,IX(LCLN),X(LCTOFF),
     &                                NPLIST,ITS,NQAR,NQCAR,NQTAR,
     &                                NGHBVL,IERR,IERRU,ND)
                  IF (IUNIT(18).NE.0)
     &                CALL OBS1STR6DR(NQ,IX(LCNQOB),IX(LCNQCL),
     &                                IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                                GZ(LCHNEW),IP,Z(LCSNEW),NCOL,NROW,
     &                                NLAY,IOUTG,IG(LCIBOU),NHT,X(LCX),
     &                                OBSNAM,NPE,IX(LCLN),X(LCTOFF),
     &                                MXSTRM,NSTREM,RX(LCSTRM_),
     &                                IR(ICSTRM_),NPLIST,ITS,NQAR,NQCAR,
     &                                NQTAR,IERR,IERRU,ND)
                  IF (IUNIT(38).NE.0)
     &                CALL OBS1BAS6FDR(NQ,IX(LCNQOB),IX(LCNQCL),
     &                                 IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                                 GZ(LCHNEW),IP,Z(LCSNEW),NCOL,
     &                                 NROW,NLAY,IG(LCIBOU),NHT,
     &                                 X(LCX),X(LCTOFF),ITS,NQAR,NQCAR,
     &                                 NQTAR,ICHFLG,GX(LCBOTM),NBOTM,
     &                                 PIDTMP,LAYHDT,GX(LCRMLT),NMLTAR,
     &                                 IG(LCIZON),NZONAR,GX(LCDELC),
     &                                 GX(LCDELR),RX(LCHFB),NHFB,
     &                                 IUNIT(21),MXACTFB,X(LCSV),
     &                                 X(LCVKA),X(LCHK),X(LCHANI),
     &                                 GX(LCCR),GX(LCCC),GX(LCCV),NPE,
     &                                 IERR,IERRU,IOUTG,IUNIT(23),
     &                                 IX(LCLN),NPLIST,ND)
                  IF (IUNIT(40).NE.0)
     &                CALL OBS1DRT1DR(NQ,IX(LCNQOB),IX(LCNQCL),
     &                                IX(LCIQOB),X(LCQCLS),IX(LCIBT),
     &                                GZ(LCHNEW),IP,Z(LCSNEW),NCOL,NROW,
     &                                NLAY,IOUTG,IG(LCIBOU),NHT,X(LCX),
     &                                OBSNAM,NPE,IX(LCLN),X(LCTOFF),
     &                                MXDRT,NDRTCL,RX(LCDRTF),NPLIST,
     &                                ITS,NQAR,NQCAR,NQTAR,NDRTVL,IERR,
     &                                IERRU,ND)
                  IF (IERR.GT.0) GOTO 85
                ENDIF
                IF (IUNIT(29).NE.0 .AND. ISSFLG(KKPER).EQ.1)
     &            CALL OBS1ADV2P(NROW,NCOL,NLAY,GX(LCDELC),GX(LCDELR),
     &                           IOUT,GX(LCCR),GX(LCCC),GX(LCCV),
     &                           GZ(LCHNEW),IG(LCIBOU),OBSNAM,X(LCPOFF),
     &                           NHT,NQT,NTT2,NPTH,IX(LCNPNT),KTDIM,
     &                           KTFLG,KTREV,ADVSTP,
     &                           IX(LCICLS),X(LCPRST),IP,GX(LCRMLT),
     &                           X(LCHK),IG(LCIZON),X(LCH),
     &                           X(LCX),NPE,ND,X(LCTT2),IPRINT,ITERP,
     &                           IOUTT2,MXBND,NBOUND,RX(LCBNDS),NRCHOP,
     &                           IR(LCIRCH),RX(LCRECH),MXSTRM,NSTREM,
     &                           IR(ICSTRM_),RX(LCSTRM_),MXRIVR,NRIVER,
     &                           RX(LCRIVR),MXDRN,NDRAIN,RX(LCDRAI),
     &                           X(LCSV),NMLTAR,NZONAR,GX(LCBOTM),NBOTM,
     &                           RX(LCWELL),NWELVL,MXWELL,NWELLS,
     &                           Z(LCSNEW),X(LCVKA),
     &                           IUNIT(21),RX(LCHFB),MXACTFB,NHFB,
     &                           X(LCHANI),NGHBVL,NRIVVL,NDRNVL,LAYHDT,
     &                           IX(LCLN),NPLIST,ISCALS,FSNK,X(LCWTQ),
     &                           NDMH,X(LCBSCA),X(LCHKCC),X(LCHUFTHK),
     &                           NHUF,IUNIT(23),IUNIT(37))
              ENDIF
C-------IF CONVERGENCE ACHIEVED BY SUM OF SQUARES CRITERIA (SOSC)
              IF (IFO.EQ.2) THEN
C-----------GO TO KSTP LOOP WHEN DONE WITH PARAMETERS
                IF (IP.EQ.NPE) THEN
                  ITERPF = ITERP
                  GOTO 90
                ENDIF
              ENDIF
C-------SAVE CURRENT SENSITIVITY ARRAY
              IF (IFO.EQ.0 .OR. LASTX.NE.0)
     &            CALL SEN1BAS6TM(NCOL,NROW,NLAY,IUHEAD,IP,GX(LCBUFF),
     &                            XHS,LENXHS,Z(LCSNEW))
C
C-------END OF SENSITIVITY LOOP
   80       CONTINUE
C
   85       CONTINUE
            CALL PLL1BR()
            CALL PLL1EH(IERR,IERRU,IOUT,IOUTG,MINERR)
C-----END OF TIME STEP (KSTP) AND STRESS PERIOD (KPER) LOOPS
   90     CONTINUE
  100   CONTINUE
C
        CALL PLL1BR()
        IF (ISEN.GT.0) THEN
          CALL PLL1MX(X(LCX),X(LCXND),NPE,ND)
          IF (IFO.NE.1 .OR. LASTX.GT.0)
     &        CALL SEN1BAS6PD(IOUT,NPE,NPER,NSTP,NTIMES,X(LCSEND),
     &                        X(LCSNDT))
        ENDIF
C
C       PRINT DATA FOR OBSERVED HEADS AND FLOWS.
        IF (ND.GT.0 .AND. (IFO.NE.1 .OR. LASTX.NE.0))
     &      CALL OBS1BAS6OT(IOUT,IOUTG,NPE,NH,OBSNAM,X(LCBUF1),X(LCX),
     &                      X(LCH),X(LCWT),X(LCHOBS),IPRINT,IFO,ITERP,
     &                      IPAR,IX(LCLN),ISCALS,X(LCWP),MPR,X(LCPRM),
     &                      RSQ,RSQP,RSQO,RSQOO,SOSC,SOSR,IPR,
     &                      IX(LCNIPR),X(LCWTPS),ND,RSQF,X(LCWTQ),
     &                      X(LCWTQS),IOWTQ,NDMH,NTT2,KTDIM,NPLIST,
     &                      MPRAR,IPRAR,OUTNAM,IX(LCIPLO),EQNAM,NAMES,
     &                      IX(LCIPLP),NDMHAR,NQTDR,NQTRV,NQTGB,NQTST,
     &                      NQTCH,IOWTQDR,IOWTQRV,IOWTQGB,IOWTQST,
     &                      LCOBBAS,LCOBDRN,LCOBRIV,LCOBGHB,LCOBSTR,
     &                      LCOBCHD,LCOBADV,X(LCSSGF),X(LCSSDR),
     &                      X(LCSSRV),X(LCSSGB),X(LCSSST),X(LCSSAD),
     &                      X(LCSSCH),X(LCSSPI),X(LCSSTO),ITMXP,
     &                      X(LCBUF2),IPES,X(LCBPRI),X(LCBSCA),LCOBDRT,
     &                      X(LCSSDT),NQTDT,IOWTQDT,NRES,NPOST,
     &                      NNEGT,NRUNS,NQTSF,IOWTQSF,LCOBSFR,X(LCSSSF),
     &                      NHT)
C       PARALLEL CONVERGENCE TEST
        CALL PLL1CV(IFO)
C-------IF CONVERGENCE ACHIEVED BY SUM OF SQUARES CRITERIA (SOSC)
        IF (IFO.EQ.2) THEN
          ITERPF = ITERP
        ENDIF
C
C-----NONLINEAR REGRESSION BY MODIFIED GAUSS-NEWTON
        IF (IPES.GT.0) THEN
          IF (IYCFLG.LT.1) THEN
C---------EXECUTE ONE GAUSS-NEWTON ITERATION
            IF (MYID.EQ.MPROC) THEN
              CALL PES1GAU1AP(X(LCX),ND,NPE,X(LCHOBS),X(LCWT),X(LCWP),
     &                        Z(LCC),Z(LCSCLE),Z(LCG),X(LCH),Z(LCDD),
     &                        DMAX,CSA,TOL,IND,IFO,AMP,AP,DMX,IOUTG,
     &                        X(LCB1),ITERP,IPRINT,IX(LCLN),MPR,
     &                        X(LCPRM),JMAX,NFIT,Z(LCR),Z(LCGD),
     &                        Z(LCU),NOPT,X(LCXD),Z(LCS),SOSR,
     &                        IX(LCNIPR),IPR,GX(LCBUFF),X(LCWTP),NHT,
     &                        X(LCWTQ),IOWTQ,NDMH,IOSTAR,NPLIST,MPRAR,
     &                        IPRAR,NDMHAR,X(LCBPRI),RMARM,IAP,
     &                        Z(LCDMXA),IX(LCNPAR),X(LCAMPA),X(LCAMCA),
     &                        X(LCAAP),ITMXP,RMAR)
C---------FINAL OUTPUT:
C-----------PRINT SIMULATED EQUIVALENTS AND RESIDUALS IF LEAST-SQUARES
C           COEFFICIENT MATRIX IS SINGULAR OR IF PARAMETER ESTIMATION
C           DOES NOT CONVERGE
              IF (IND.GT.0 .OR. (IFO.EQ.0 .AND. KITP.EQ.ITMXP))
     &            CALL OBS1BAS6OH(X(LCWP),IOUT,NH,X(LCH),X(LCHOBS),
     &                            X(LCWT),OBSNAM,ND,MPR,X(LCPRM),RSQ,
     &                            RSQP,2,IX(LCLN),RSQH,IPR,IX(LCNIPR),
     &                            X(LCWTPS),X(LCBUF1),RSQF,
     &                            X(LCBUF1+IPRAR),
     &                            X(LCBUF1+IPRAR+ND+MPR+IPR),X(LCWTQ),
     &                            X(LCWTQS),NDMH,NTT2,KTDIM,NPLIST,
     &                            MPRAR,IPRAR,OUTNAM,IX(LCIPLO),EQNAM,
     &                            NAMES,IX(LCIPLP),NDMHAR,NQTDR,NQTRV,
     &                            NQTGB,NQTST,NQTCH,IOWTQDR,IOWTQRV,
     &                            IOWTQGB,IOWTQST,LCOBBAS,LCOBDRN,
     &                            LCOBRIV,LCOBGHB,LCOBSTR,LCOBCHD,
     &                            LCOBADV,0,X(LCSSGF),X(LCSSDR),
     &                            X(LCSSRV),X(LCSSGB),X(LCSSST),
     &                            X(LCSSAD),X(LCSSCH),X(LCSSPI),
     &                            X(LCSSTO),ITMXP,IPES,X(LCBPRI),
     &                            LCOBDRT,X(LCSSDT),NQTDT,IOWTQDT,
     &                            NRES,NPOST,NNEGT,NRUNS,NQTSF,IOWTQSF,
     &                            LCOBSFR,X(LCSSSF),NHT)
            ENDIF
          ENDIF
          CALL PLL1BR()
          IF (NUMPROCS.GT.1) THEN
            CALL PLL1CV(IFO)
            CALL PLL1CV(ITERPF)
            CALL PLL1CV(IND)
            CALL PLL1BA(B,MXPAR)
          ENDIF
          IF (IYCFLG.LT.1) THEN
            IF (IFO.GT.0 .AND. IND.EQ.0 .AND. ITERPF.EQ.0) GOTO 20
C
C     IF PARAMETER ESTIMATION DOES NOT CONVERGE, PRINT
C     OBSERVATION-SENSITIVITY TABLE(S)
            IF (ND.GT.0 .AND. ITERP.EQ.ITMXP .AND. IFO.EQ.0)
     &          CALL OBS1BAS6NC(X(LCBUF1),X(LCBUF2),IOUTG,IOWTQ,
     &                          IX(LCIPLO),IPR,ISCALS,ITERP,IX(LCLN),
     &                          MPR,ND,NDMH,NDMHAR,NHT,NPE,NPLIST,
     &                          OBSNAM,OUTNAM,X(LCWT),X(LCWTQ),
     &                          X(LCWTQS),X(LCX),X(LCBSCA))
C
C-----------PRINT FINAL PARAMETER-ESTIMATION OUTPUT
C
C           WRITE CONTRIBUTIONS TO SSWR OF EACH OBSERVATION TYPE AND
C           PRIOR INFORMATION FOR EACH PARAMETER-ESTIMATION ITERATION
C           TO _ss FILE
            IF ((IFO.GT.0 .OR. ITERP.EQ.ITMXP) .AND. OUTNAM.NE.'NONE'
     &          .AND. MYID.EQ.MPROC) THEN
              CALL OBS1BAS6PR1(IFO,IOUTG,ITERPK,ITERSS,ITMXP,IUSS,
     &                         IX(LCNPAR),OUTNAM)
              IF (NH.GT.0) CALL OBS1BAS6HPR(ITERSS,ITMXP,IUSS,X(LCSSGF))
              IF (NQTCH.GT.0) CALL OBS1BAS6FPR(ITERSS,ITMXP,IUSS,
     &                                         X(LCSSCH))
              IF (NQTDR.GT.0) CALL OBS1DRN6PR(ITERSS,ITMXP,IUSS,
     &                                        X(LCSSDR))
              IF (NQTDT.GT.0) CALL OBS1DRT1PR(ITERSS,ITMXP,IUSS,
     &                                        X(LCSSDT))
              IF (NQTRV.GT.0) CALL OBS1RIV6PR(ITERSS,ITMXP,IUSS,
     &                                        X(LCSSRV))
              IF (NQTGB.GT.0) CALL OBS1GHB6PR(ITERSS,ITMXP,IUSS,
     &                                        X(LCSSGB))
              IF (NQTST.GT.0) CALL OBS1STR6PR(ITERSS,ITMXP,IUSS,
     &                                        X(LCSSST))
              IF (NOBADV.GT.0) CALL OBS1ADV2PR(ITERSS,ITMXP,IUSS,
     &                                         X(LCSSAD))
              IF (MPR.GT.0 .OR. IPR.GT.0)
     &            CALL PES1BAS6PR(ITERSS,ITMXP,IUSS,X(LCSSPI))
              CALL OBS1BAS6PR2(IPR,ITERSS,ITMXP,IUSS,MPR,X(LCSSTO))
            ENDIF
C
C           WRITE PARAMETER-ESTIMATION OUTPUT TO GLOBAL FILE
            CALL PES1BAS6OT(Z(LCC),X(LCWT),NPE,RSQ,IOUTG,GX(LCBUFF),ND,
     &                      IPRC,IFO,IND,Z(LCSCLE),X(LCHOBS),X(LCH),
     &                      X(LCB1),X(LCWP),ITERPF,IX(LCLN),MPR,
     &                      X(LCPRM),LPRINT,IDRY,EV,RSQP,VAR,IPR,
     &                      IX(LCNIPR),X(LCWTPS),DETWTP,X(LCBL),X(LCBU),
     &                      Z(LCEIGL),Z(LCEIGV),Z(LCEIGW),NHT,X(LCWTQ),
     &                      X(LCWTQS),DTLWTQ,IOWTQ,NDMH,NPLIST,MPRAR,
     &                      IPRAR,IOUB,IX(LCISEN),IBEALE,ITERP,ITMXP,
     &                      NDMHAR,X(LCPRNT),OUTNAM,X(LCPARE),X(LCSSPI),
     &                      X(LCSSTO),IX(LCNPAR),Z(LCDMXA),X(LCBPRI),
     &                      X(LCBSCA),IPRINT,X(LCAAP),X(LCAMCA),
     &                      X(LCRSQA),X(LCRSPA),X(LCAMPA),ITERPK)
            IF (IFO.EQ.0 .AND. ITERP.EQ.ITMXP) GOTO 110
C
          ENDIF
        ENDIF
C-------GENERATE INPUT FILE(S) FOR RESAN-2000, BEALE-2000 AND YCINT-2000
        IF (MYID.EQ.MPROC) THEN
          IF (IYCFLG.LT.1 .AND. IPES.GT.0)
     &        CALL PES1BAS6RS(NPE,ND,NDMH,VAR,Z(LCC),X(LCWT),NHT,
     &                        X(LCWTQS),X(LCX),MPR,X(LCPRM),X(LCWP),
     &                        NPLIST,MPRAR,NDMHAR,OUTNAM,X(LCWTPS),
     &                        IPR,IPRAR,IX(LCNIPR),RSQP,IDRY)
          IF (IBEFLG.GT.0 .AND. (IPES.LE.0 .OR. (IPES.GT.0 .AND.
     &        IFO.GT.0)))
     &        CALL PES1BAS6BE(NPE,ND,MPR,VAR,X(LCH),X(LCWT),X(LCX),
     &                        X(LCWP),IX(LCLN),X(LCPRM),X(LCHOBS),
     &                        Z(LCC),IBEALE,ITERPK,IOUT,OBSNAM,
     &                        GX(LCBUFF),NHT,NDMH,X(LCWTQ),NPLIST,MPRAR,
     &                        IBEFLG,OUTNAM,IUBE,BEFIRST,FSTAT,IERR,
     &                        IERRU,NDMHAR,X(LCWTP),IPR,IPRAR,X(LCBPRI),
     &                        IX(LCNIPR))
          IF (IERR.GT.0) GOTO 103
          IF (IYCFLG.GT.-1)
     &        CALL PES1BAS6YC(NPE,ND,MPR,X(LCH),X(LCWT),X(LCX),Z(LCC),
     &                        IOUT,OBSNAM,NHT,NDMH,X(LCWTQ),OUTNAM,
     &                        IYCFLG,IPR,IX(LCIPLO),IERR,IERRU,NDMHAR)
          IF (IERR.GT.0) GOTO 103
        ENDIF
  103   CONTINUE
        CALL PLL1BR()
        CALL PLL1EH(IERR,IERRU,IOUT,IOUTG,MINERR)
        IF (IBEFLG.EQ.2 .AND. IBEALE.NE.0) GOTO 20
        IF (ITERPF.GT.0) GOTO  107
C
C     END OF PARAMETER-ESTIMATION LOOP
  105 CONTINUE
C
  107 CONTINUE
C-------RESIDUAL ANALYSIS
C        OBS1BAS6RE CHANGES H AND MAY CHANGE HOBS
      IF (MYID.EQ.MPROC) THEN
        IF (ND.GT.0)
     &      CALL OBS1BAS6RE(X(LCWP),IOUTG,IOUT,NHT,X(LCH),X(LCHOBS),
     &                      X(LCWT),NDMH,ND,IPAR,MPR,X(LCPRM),IPR,
     &                      IX(LCNIPR),X(LCWTPS),X(LCBUF1),LBUFF,
     &                      X(LCWTQ),X(LCWTQS),NPLIST,MPRAR,IPRAR,
     &                      NDMHAR,NAMES,IX(LCOBSE),X(LCBPRI),RSQP,
     &                      NRES,NPOST,NNEGT,NRUNS)
C
C       PRINT FINAL PARAMETER-ESTIMATION OUTPUT
        IF (IPES.GT.0 .AND. IYCFLG.LT.1)
     &      CALL PES1BAS6FO(ICNVGP,IFO,IOUTG)
      ENDIF
C
  110 CONTINUE
C8------END OF SIMULATION
      CALL GLO1BAS6ET(IBDT,IOUTG,IPRTIM)
      CALL CLOSEFILES(INUNIT,FNAME)
      IF (IBATCH.GT.0) THEN
C       TO USE STATIC MEMORY ALLOCATION, COMMENT OUT THE FOLLOWING
C       DEALLOCATE STATEMENT
        DEALLOCATE (GX,GZ,IG,X,Z,IX,XHS,RX,IR,NIPRNAM,EQNAM,NAMES,
     &              OBSNAM)
        GOTO 10
      ENDIF
C
C     HANDLE WARNINGS AND ERRORS
      CALL PLL1BR()
      CALL PLL1EH(IERR,IERRU,IOUT,IOUTG,MINERR)
      IF (MINERR.LT.0) CALL PLL1SD(IERR,IERRU,IOUT,IOUTG)
      CALL PLL1DE(IERRU,IOUT,IOUTG)
C
  120 CONTINUE
C
      CALL PLL1CL()
      WRITE(*,121)
121   FORMAT(1X,'Normal termination of MODFLOW-2000')
      STOP
C
      END

