C  Distribute irrigation returns based on area cell mapping
C  Willem A. Schreuder
C  May 5, 2003
      PROGRAM MKSW
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXAREA=256,MINYR=1940,MAXYR=2050)
      PARAMETER (NROW=165,NCOL=326)
      PARAMETER (X0=266023,Y0=14092806,DX=5280,DY=5280)
      DIMENSION ACRES(NCOL,NROW,MAXAREA),SUMACRES(MAXAREA)
      DIMENSION IBOUND(NCOL,NROW)
      DIMENSION RETAF(12,MINYR:MAXYR,MAXAREA)
      DIMENSION RECH(NCOL,NROW),AREA(NCOL,NROW)
      LOGICAL       RETF,BIN
      CHARACTER*16  CMD,DIR,RCS,ARG
      CHARACTER*32  NAME(MAXAREA)
      CHARACTER*256 FILE
      CHARACTER*256 CHARIN
      CHARACTER*8192 LINE

C  Define domain
      X1 = X0 + NCOL*DX
      Y1 = Y0 + NROW*DY

C  Set defaults
      BIN   = .FALSE.
      DIR   = ' '
      RCS   = ' '
      ARG   = ' '
      IYR0  = 0
      IYR1  = 0
      NAREA = 0
      RETF  = .FALSE.
      do I=1,NROW
        do J=1,NCOL
          IBOUND(J,I) = 1
        enddo
      enddo

C======================================================================C
C====================  Read and process parameters  ===================C
C======================================================================C
      if (IARGC().ne.1) call ERROR('Usage: mksw <parameter file>')
      call GETARG(1,FILE)
      OPEN(1,FILE=FILE,STATUS='OLD',IOSTAT=IOS)
      if (IOS.ne.0) call ERROR('Error opening parameter file')
100   READ(1,'(A)',END=199) LINE
      if (LINEFIX(LINE).ne.0) goto 100
      CMD = CHARIN(LINE,1,IPOS,IOS)
      if (IOS.ne.0) call ERROR('Invalid command '//LINE)
      call UPPERCASE(CMD)

C---------------  File directory, extension and type   ----------------C
      if (CMD.eq.'FILE') then
        DIR = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid FILE directory')
        RCS = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid FILE recharge extension')
        ARG = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid FILE area/rate extension')
        CMD = CHARIN(LINE,IPOS,IPOS,IOS)
        call UPPERCASE(CMD)
        if (CMD.eq.'BIN') then
          BIN = .TRUE.
        else if (IOS.eq.0) then
          call ERROR('Unknown FILE option '//CMD)
        endif
C--------------  Years to use for transient calculation  --------------C
      elseif (CMD.eq.'TRANSIENT') then
        IYR0 = INTIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid TRANSIENT start year')
        IYR1 = INTIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid TRANSIENT end year')
        if (IYR0.gt.IYR1) call ERROR('Invalid TRANSIENT period')
C----------------------  Load IBOUNDs from file  ----------------------C
      elseif (CMD.eq.'IBOUND') then
        FILE = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid IBOUND file name '//LINE)
        call READFLAGS(FILE,IBOUND,NROW,NCOL,LINE,N,0)
C------------------------  Read return areas  -------------------------C
      elseif (CMD.eq.'AREA') then
        if (RETF) call ERROR('Specify AREAs before RETURNs')
        NAREA = NAREA+1
        if (NAREA.gt.MAXAREA) call ERROR('Too many AREAs')
        NAME(NAREA) = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid AREA name '//LINE)
        call UPPERCASE(NAME(NAREA))
        FILE = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid AREA file '//LINE)
C       Read cell-by-cell area
        if (FILE .eq. '*') then
          do I=1,NROW
            do J=1,NCOL
              ACRES(J,I,NAREA) = 0
            enddo
          enddo
          X = REALIN(LINE,IPOS,IPOS,IOS)
          if (IOS.ne.0) call ERROR('Invalid AREA X coordinate')
          Y = REALIN(LINE,IPOS,IPOS,IOS)
          if (IOS.ne.0) call ERROR('Invalid AREA Y coordinate')
          if (X.lt.X0 .or. X.gt.X1  .or.
     |        Y.lt.Y0 .or. Y.gt.Y1) then
            print *,'AREA outside domain ',LINE(1:LENGTH(LINE))
          else
            J = INT((X-X0)/DX)+1
            I = NROW-INT((Y-Y0)/DY)
            ACRES(J,I,NAREA) = REALIN(LINE,IPOS,IPOS,IOS)
            if (IOS.ne.0) call ERROR('Invalid AREA acres')
          endif
        else
          call READREAL(FILE,ACRES(1,1,NAREA),NROW,NCOL,1)
        endif
C---------------------  Load RETURNs from file  -----------------------C
      elseif (CMD.eq.'RETURN') then
        if (NAREA.eq.0) call ERROR('Specify AREAs before RETURNs')
        RETF = .TRUE.
        FILE = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid RETURNs file '//LINE)
        call READMONTHS(FILE,RETAF,NAME,NAREA,MINYR,MAXYR)
C  Duh!
      else
        call ERROR('Unknown parameter '//CMD)
      endif
      goto 100
199   CLOSE(1)

C  Sanity checks
      if (LENGTH0(DIR).eq.0) call ERROR('No FILE specified')
      if (NAREA.eq.0) call ERROR('No AREAs specified')
      if (.not.RETF)  call ERROR('No RETURNs specified')
C  Calculate total areas
      do L=1,NAREA
        SUMACRES(L) = 0
        do I=1,NROW
          do J=1,NCOL
            SUMACRES(L) = SUMACRES(L) + ACRES(J,I,L)
          enddo
        enddo
      enddo

C======================================================================C
C=========================  Calculate returns  ========================C
C======================================================================C
      do IYR=IYR0,IYR1
        do MO=1,12
C  Calculate return flows in acre-feet by cell
          SUM = 0
          do L=1,NAREA
            SUM = SUM + RETAF(MO,IYR,L)
          enddo
          if (SUM.ne.0) then
C  Calculate cell by cell recharge
            do I=1,NROW
              do J=1,NCOL
                RECH(J,I) = 0
                if (IBOUND(J,I).ne.0) then
                  do L=1,NAREA
                    RECH(J,I) = RECH(J,I) +
     |                ACRES(J,I,L)/SUMACRES(L)*RETAF(MO,IYR,L)
                  enddo
                endif
              enddo
            enddo
C  Save monthly values
            call STOREMONTH(RECH,1D0,NROW,NCOL,IYR,MO,DIR,RCS,BIN)
          endif
        enddo
C  Calculate annual diversions by area
        do I=1,NROW
          do J=1,NCOL
            AREA(J,I) = 0
          enddo
        enddo
C  Calculate total annual diversion
        do L=1,NAREA
          SUM = 0
          do MO=1,12
            SUM = SUM + RETAF(MO,IYR,L)
          enddo
          if (SUM.ne.0) then
            do I=1,NROW
              do J=1,NCOL
                if (IBOUND(J,I).ne.0) then
                  AREA(J,I) = AREA(J,I) + ACRES(J,I,L)
                endif
              enddo
            enddo
          endif
        enddo
        call STOREMONTH(AREA,1D0,NROW,NCOL,IYR,-1,DIR,ARG,BIN)
      enddo
      END
C----------------------------------------------------------------------C
C-------------------  Read annual factors from file  ------------------C
C----------------------------------------------------------------------C
      SUBROUTINE READMONTHS(FILE,RET,NAME,NAREA,MINYR,MAXYR)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION      RET(12,MINYR:MAXYR,NAREA)
      CHARACTER*32   NAME(NAREA)
      CHARACTER*1024 LINE
      CHARACTER*(*)  FILE

C  Initialize
      do L=1,NAREA
        do IYR=MINYR,MAXYR
          do MO=1,12
            RET(MO,IYR,L) = 0
          enddo
        enddo
      enddo
C  Read
      OPEN(8,FILE=FILE,STATUS='OLD',IOSTAT=IOS)
      if (IOS.ne.0) call ERROR2('Cannot open file',FILE)
C  Read names from first line
      READ(8,'(A)',IOSTAT=IOS) LINE
      if (IOS.ne.0) call ERROR2('Cannot read file',FILE)
      call CHECKHDR(FILE,LINE,NAME,NAREA)
C  Read data
100   READ(8,'(A)',END=199) LINE
      if (LINEFIX(LINE).ne.0) goto 100
      K = INTIN(LINE,1,IPOS,IOS)
      if (IOS.ne.0) call ERROR2('Invalid year-mo in file',FILE)
      IYR = K/100
      MO  = MOD(K,100)
      if (IYR.lt.MINYR .or. IYR.gt.MAXYR) goto 100
      if (MO.lt.1 .or. MO.gt.12) call ERRORINT('Invalid year-month',MO)
      do L=1,NAREA
        RET(MO,IYR,L) = REALIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR2('Invalid data in file',FILE)
      enddo
      goto 100
199   CLOSE(8)
      END
