C  Distribute well pumping on area basis to individual cells
C  Willem A. Schreuder
C  May 5, 2003
      PROGRAM MKGW
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXWEL=30000,MAXAREA=256,MINYR=1918,MAXYR=2020)
      PARAMETER (NROW=165,NCOL=326)
      PARAMETER (X0=266023,Y0=14092806,DX=5280,DY=5280)
      DIMENSION IROW(MAXWEL),ICOL(MAXWEL),IDAREA(MAXWEL)
      DIMENSION APPROP(MINYR:MAXYR,MAXWEL)
      DIMENSION PUMPING(MINYR:MAXYR,MAXAREA)
      DIMENSION RETURNS(MINYR:MAXYR,MAXAREA)
      DIMENSION ACRES(MINYR:MAXYR,MAXAREA)
      DIMENSION IBOUND(NCOL,NROW),FMON(12)
      DIMENSION FACT(0:12,MAXAREA),TOTAL(MAXAREA)
      DIMENSION DIST(12,MINYR:MAXYR,MAXAREA)
      DIMENSION WELL(NCOL,NROW),RECH(NCOL,NROW)
      DIMENSION AREA(NCOL,NROW)
      LOGICAL       EOL,BIN,NET,AGW,ANN,YEARS
      CHARACTER*16  CMD,DIR,PMP,RCG,ARG
      CHARACTER*32  STRING,NAME(MAXAREA)
      CHARACTER*256 FILE
      CHARACTER*256 CHARIN
      CHARACTER*8192 LINE

C  Define domain
      X1 = X0 + NCOL*DX
      Y1 = Y0 + NROW*DY

C  Set defaults
      BIN   = .FALSE.
      NET   = .FALSE.
      AGW   = .FALSE.
      ANN   = .TRUE.
      DIR   = ' '
      PMP   = ' '
      RCG   = ' '
      ARG   = ' '
      IYR0  = 0
      IYR1  = 0
      NAREA = 0
      NWEL  = 0
      do L=1,MAXAREA
        do IYR=MINYR,MAXYR
          do M=1,12
            DIST(M,IYR,L) = 0
          enddo
        enddo
      enddo
      do I=1,NROW
        do J=1,NCOL
          IBOUND(J,I) = 1
        enddo
      enddo

C======================================================================C
C====================  Read and process parameters  ===================C
C======================================================================C
      if (IARGC().ne.1) call ERROR('Usage: mkgw <parameter file>')
      call GETARG(1,FILE)
      OPEN(1,FILE=FILE,STATUS='OLD',IOSTAT=IOS)
      if (IOS.ne.0) call ERROR('Error opening parameter file')
100   READ(1,'(A)',END=199) LINE
      if (LINEFIX(LINE).ne.0) goto 100
      CMD = CHARIN(LINE,1,IPOS,IOS)
      if (IOS.ne.0) call ERROR('Invalid command '//LINE)
      call UPPERCASE(CMD)

C---------------  File directory, extension and type   ----------------C
      if (CMD.eq.'FILE') then
        DIR = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid FILE directory')
        PMP = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid FILE pumping extension')
        RCG = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid FILE recharge extension')
        ARG = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid FILE acres/rate extension')
        CMD = CHARIN(LINE,IPOS,IPOS,IOS)
        do while (IOS.eq.0)
          call UPPERCASE(CMD)
          if (CMD.eq.'BIN') then
            BIN = .TRUE.
          else if (IOS.eq.0) then
            call ERROR('Unknown FILE option '//CMD)
          endif
          CMD = CHARIN(LINE,IPOS,IPOS,IOS)
        enddo
C--------------  Years to use for transient calculation  --------------C
      elseif (CMD.eq.'TRANSIENT') then
        IYR0 = INTIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid TRANSIENT start year')
        IYR1 = INTIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid TRANSIENT end year')
        if (IYR0.gt.IYR1) call ERROR('Invalid TRANSIENT period')
C----------------------  Load IBOUNDs from file  ----------------------C
      elseif (CMD.eq.'IBOUND') then
        FILE = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid IBOUND file name '//LINE)
        call READFLAGS(FILE,IBOUND,NROW,NCOL,LINE,N,0)
C-----------  Read factors for annual to monthly conversion  ----------C
      elseif (CMD.eq.'MONTH') then
        ANN = .FALSE.
        if (NAREA.eq.0) call ERROR('Define AREA before MONTH factors')
        DUMMY = REALIN(LINE,IPOS,JPOS,IOS)
C       Read one set of monthly factors
        if (IOS.eq.0) then
          call GETMONTH(LINE,IPOS,FMON)
          do L=1,NAREA
            do IYR=MINYR,MAXYR
              do M=1,12
                DIST(M,IYR,L) = FMON(M)
              enddo
            enddo
          enddo
C       Read monthly factors by area
        else
          FILE = CHARIN(LINE,IPOS,IPOS,IOS)
          if (IOS.ne.0) call ERROR('Invalid MONTH file name '//LINE)
          OPEN(8,FILE=FILE,STATUS='OLD',IOSTAT=IOS)
          if (IOS.ne.0) call ERROR('Error opening MONTH file '//FILE)
          READ(8,'(A)',IOSTAT=IOS) LINE
          do while (IOS.eq.0)
            if (LINEFIX(LINE).eq.0) then
              STRING = CHARIN(LINE,1,IPOS,IOS)
              if (IOS.ne.0) call ERROR('Invalid MONTH area '//LINE)
              call UPPERCASE(STRING)
              do L=1,NAREA
                if (STRING.eq.NAME(L)) goto 110
              enddo
              call ERROR('Unknown MONTH area '//STRING)
110           IYR = INTIN(LINE,IPOS,IPOS,IOS)
              call GETMONTH(LINE,IPOS,FMON)
              if (MINYR.le.IYR .and. IYR.le.MAXYR) then
                do M=1,12
                  DIST(M,IYR,L) = FMON(M)
                enddo
              endif
            endif
            READ(8,'(A)',IOSTAT=IOS) LINE
          enddo
          CLOSE(8)
        endif
C---------------------------  Define areas  ---------------------------C
      elseif (CMD.eq.'AREA') then
        NAREA = 0
        do while (.not.EOL(LINE,IPOS))
          NAREA = NAREA+1
          if (NAREA.gt.MAXAREA) call ERROR('Too many AREAs')
          NAME(NAREA) = CHARIN(LINE,IPOS,IPOS,IOS)
          if (IOS.ne.0) call ERROR('Invalid AREA '//LINE)
          call UPPERCASE(NAME(NAREA))
        enddo
C-----------------------  Load WELLs from file  -----------------------C
      elseif (CMD.eq.'WELL') then
        if (NAREA.eq.0) call ERROR('Define AREA before WELL')
        FILE = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid WELL file name '//LINE)
        OPEN(8,FILE=FILE,STATUS='OLD',IOSTAT=IOS)
        if (IOS.ne.0) call ERROR('Error opening WELL file '//FILE)
        KYR0 = INTIN(LINE,IPOS,IPOS,IOS)
        YEARS = (IOS.eq.0)
        if (YEARS) then
          KYR1 = INTIN(LINE,IPOS,IPOS,IOS)
          if (IOS.ne.0 .or. KYR0.eq.0 .or. KYR1.lt.KYR0)
     |      call ERROR('Invalid WELL years')
        else
          KYR0 = 0
          KYR1 = 0
        endif
        NWEL = 0
        READ(8,'(A)',IOSTAT=IOS) LINE
        do while (IOS.eq.0)
          if (LINEFIX(LINE).eq.0) then
            XWEL = REALIN(LINE,1,IPOS,IOS)
            if (IOS.ne.0) call ERROR('Invalid well X coordinate '//LINE)
            YWEL = REALIN(LINE,IPOS,IPOS,IOS)
            if (IOS.ne.0) call ERROR('Invalid well Y coordinate '//LINE)
            if (XWEL.lt.X0 .or. XWEL.gt.X1  .or.
     |          YWEL.lt.Y0 .or. YWEL.gt.Y1) then
              print *,'Well outside domain ',LINE(1:LENGTH(LINE))
            else
              NWEL = NWEL+1
              if (NWEL.gt.MAXWEL) call ERROR('Too many wells')
              ICOL(NWEL) = INT((XWEL-X0)/DX)+1
              IROW(NWEL) = NROW-INT((YWEL-Y0)/DY)
              STRING = CHARIN(LINE,IPOS,IPOS,IOS)
              if (IOS.ne.0) call ERROR('Invalid well area '//LINE)
              call UPPERCASE(STRING)
              do L=1,NAREA
                if (STRING.eq.NAME(L)) goto 120
              enddo
              call ERROR('Unknown well area '//STRING)
120           IDAREA(NWEL) = L
C             Read appropriation
              do IYR=MINYR,MAXYR
                APPROP(IYR,NWEL) = 0
              enddo
              if (YEARS) then
                do IYR=KYR0,KYR1
                  ACR = REALIN(LINE,IPOS,IPOS,IOS)
                  if (IOS.ne.0 .or. ACR.lt.0)
     |              call ERROR('Invalid well acres '//LINE)
                  if (MINYR.le.IYR .and. IYR.le.MAXYR)
     |              APPROP(IYR,NWEL) = ACR
                enddo
              else
                KYR0 = INTIN(LINE,IPOS,IPOS,IOS)
                if (IOS.ne.0) call ERROR('Invalid well year '//LINE)
                if (KYR0.gt.9999) KYR0 = KYR0/10000
                KYR1 = INTIN(LINE,IPOS,IPOS,IOS)
                if (IOS.ne.0) call ERROR('Invalid abandon year '//LINE)
                if (KYR1.gt.9999) KYR1 = KYR1/10000
                ACR = REALIN(LINE,IPOS,IPOS,IOS)
                if (IOS.ne.0 .or. ACR.lt.0)
     |            call ERROR('Invalid well acres '//LINE)
                do IYR=MAX(MINYR,KYR0),MIN(MAXYR,KYR1)
                  APPROP(IYR,NWEL) = ACR
                enddo
              endif
            endif
          endif
          READ(8,'(A)',IOSTAT=IOS) LINE
        enddo
        CLOSE(8)
C----------------------  Load PUMPING from file  ----------------------C
      elseif (CMD.eq.'PUMPING') then
        if (NAREA.eq.0) call ERROR('Define AREA before PUMPING')
        FILE = CHARIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0) call ERROR('Invalid PUMPING file '//LINE)
        call READYEARS(FILE,PUMPING,NAME,NAREA,MINYR,MAXYR)
        NET = EOL(LINE,IPOS)
        if (.not.NET) then
          FILE = CHARIN(LINE,IPOS,IPOS,IOS)
          if (IOS.ne.0) call ERROR('Invalid RETURNS file '//LINE)
          call READYEARS(FILE,RETURNS,NAME,NAREA,MINYR,MAXYR)
          AGW = .NOT.EOL(LINE,IPOS)
        else
          AGW = .FALSE.
        endif
        if (AGW) then
          FILE = CHARIN(LINE,IPOS,IPOS,IOS)
          if (IOS.ne.0) call ERROR('Invalid ACRES file '//LINE)
          call READYEARS(FILE,ACRES,NAME,NAREA,MINYR,MAXYR)
        endif
C  Duh!
      else
        call ERROR('Unknown parameter '//CMD)
      endif
      goto 100
199   CLOSE(1)

C  Sanity checks
      if (LENGTH0(DIR).eq.0) call ERROR('No FILE specified')
      if (NWEL.eq.0)  call ERROR('No WELLs specified')
      if (NAREA.eq.0) call ERROR('No PUMPING specified')
C  Check for wells in dead cells
      do K=1,NWEL
        if (IBOUND(ICOL(K),IROW(K)).eq.0) then
          L = IDAREA(K)
          print *,'Well in dead zone ',IROW(K),ICOL(K),
     |        ' area ',NAME(L)(1:LENGTH(NAME(L)))
          do IYR=MINYR,MAXYR
            APPROP(IYR,K) = 0
          enddo
        endif
      enddo
C  Adjust appropriated acres if requested
      if (AGW) then
        do IYR=IYR0,IYR1
C         Determine total acres by area
          do L=1,NAREA
            TOTAL(L) = 0
          enddo
          do K=1,NWEL
            L = IDAREA(K)
            TOTAL(L) = TOTAL(L) + APPROP(IYR,K)
          enddo
C         Adjustment to appropriated acres to match total acres
          do L=1,NAREA
            if (TOTAL(L).eq.0 .and. ACRES(IYR,L).gt.0) then
              print *,'WARNING:  Acres with no appropriation ',IYR,
     |          ' area ',NAME(L)(1:LENGTH(NAME(L))),PUMPING(IYR,L)
            else
              FACT(0,L) = ACRES(IYR,L)/TOTAL(L)
            endif
          enddo
C         Apply adjustment to acres
          do K=1,NWEL
            L = IDAREA(K)
            APPROP(IYR,K) = APPROP(IYR,K)*FACT(0,L)
          enddo
        enddo
      endif

C======================================================================C
C=========================  Calculate pumping  ========================C
C======================================================================C
      do IYR=IYR0,IYR1
C  Determine active wells and total appropriation by area for this year
C     TOTAL(L) is total approrpiated pumping by area
        do L=1,NAREA
          TOTAL(L) = 0
        enddo
        do K=1,NWEL
          L = IDAREA(K)
          TOTAL(L) = TOTAL(L) + APPROP(IYR,K)
        enddo
C  Distribute total pumping by area and month
C    FACT(M,L) is factor for appropriated to actual pumping by area (M=0 => annual)
        do L=1,NAREA
          do M=0,12
            FACT(M,L) = 0
          enddo
          DSUM = 0
          do M=1,12
            DSUM = DSUM + DIST(M,IYR,L)
          enddo
          if (PUMPING(IYR,L).eq.0) then
C           Do nothing
          else if (TOTAL(L).eq.0) then
            print *,'WARNING:  Pumping with no wells ',IYR,
     |        ' area ',NAME(L)(1:LENGTH(NAME(L))),PUMPING(IYR,L)
          else if (ANN) then
            FACT(0,L) = PUMPING(IYR,L)/TOTAL(L)
          else if (DSUM.eq.0) then
            print *,'WARNING:  Pumping with no MONTH ',IYR,
     |        ' area ',NAME(L)(1:LENGTH(NAME(L))),PUMPING(IYR,L)
          else
            do M=1,12
              FACT(M,L) = PUMPING(IYR,L)/TOTAL(L)*DIST(M,IYR,L)
              FACT(0,L) = FACT(0,L) + FACT(M,L)
            enddo
          endif
        enddo
        if (ANN) then
C  Calculate annual pumping in acre-feet by cell
          do I=1,NROW
            do J=1,NCOL
              WELL(J,I) = 0
              RECH(J,I) = 0
            enddo
          enddo
          do K=1,NWEL
            I = IROW(K)
            J = ICOL(K)
            L = IDAREA(K)
            Q = APPROP(IYR,K)*FACT(0,L)
            WELL(J,I) = WELL(J,I) + Q
            RECH(J,I) = RECH(J,I) + Q*RETURNS(IYR,L)
          enddo
          call STOREMONTH(WELL,1D0,NROW,NCOL,IYR,-1,DIR,PMP,BIN)
          if (.not.NET)
     |      call STOREMONTH(RECH,1D0,NROW,NCOL,IYR,-1,DIR,RCG,BIN)
        else
C  Calculate monthly pumping in acre-feet by cell
          do M=1,12
            do I=1,NROW
              do J=1,NCOL
                WELL(J,I) = 0
                RECH(J,I) = 0
              enddo
            enddo
            do K=1,NWEL
              I = IROW(K)
              J = ICOL(K)
              L = IDAREA(K)
              Q = APPROP(IYR,K)*FACT(M,L)
              WELL(J,I) = WELL(J,I) + Q
              RECH(J,I) = RECH(J,I) + Q*RETURNS(IYR,L)
            enddo
            call STOREMONTH(WELL,1D0,NROW,NCOL,IYR,M,DIR,PMP,BIN)
            if (.not.NET)
     |        call STOREMONTH(RECH,1D0,NROW,NCOL,IYR,M,DIR,RCG,BIN)
          enddo
        endif
C  Calculate irrigated acres for exclusively groundwater irrigation only
        if (ARG.ne.'*') then
          do I=1,NROW
            do J=1,NCOL
              AREA(J,I) = 0
            enddo
          enddo
          do K=1,NWEL
            if (APPROP(IYR,K).gt.0) then
              I = IROW(K)
              J = ICOL(K)
              AREA(J,I) = AREA(J,I) + APPROP(IYR,K)
            endif
          enddo
          call STOREMONTH(AREA,1D0,NROW,NCOL,IYR,-1,DIR,ARG,BIN)
        endif
      enddo
      END
C======================================================================C
C=====================  Check MONTH distribution  =====================C
C======================================================================C
      SUBROUTINE GETMONTH(LINE,IPOS,FMON)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION FMON(12)
      CHARACTER*(*) LINE

      do M=1,12
        FMON(M) = REALIN(LINE,IPOS,IPOS,IOS)
        if (IOS.ne.0 .or. FMON(M).LT.0)
     |    call ERROR2('Invalid MONTH factor',LINE)
      enddo
      SUM = 0
      do M=1,12
        SUM = SUM + FMON(M)
      enddo
      if (ABS(SUM-1).gt.0.025)
     |  call ERROR2('MONTH multipliers do not sum to 1',LINE)
      END
